/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.util.Date;
import java.util.logging.Logger;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.Update;
import org.ow2.bonita.util.Misc;

public abstract class UpdateImpl
implements Update {
    private static final long serialVersionUID = -7976662433188108616L;
    protected long dbid;
    protected long date;
    protected ActivityState state;
    protected String updateUserId;
    protected static Logger LOG = Logger.getLogger(UpdateImpl.class.getName());

    protected UpdateImpl() {
    }

    public UpdateImpl(Date date, ActivityState state, String updateUserId) {
        this.date = Misc.getTime(date);
        this.state = state;
        this.updateUserId = updateUserId;
    }

    public UpdateImpl(Update src) {
        this.date = Misc.getTime(src.getUpdatedDate());
        this.state = src.getActivityState();
        this.updateUserId = src.getUpdatedBy();
    }

    public Date getUpdatedDate() {
        return Misc.getDate(this.date);
    }

    public ActivityState getActivityState() {
        return this.state;
    }

    public String getUpdatedBy() {
        return this.updateUserId;
    }

    public static void logClockInconsistency() {
        LOG.warning("This update date is before the last update date. The recorded entries may be inconsistent. Please check your clock synchronization.");
    }
}

