/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.identity.auth;

import java.security.Principal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ow2.bonita.identity.auth.StorageLoginModule;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public abstract class SecurityContext {
    public static final String HELP = "Subject has not been set up using setSubject()!Problem may be:" + Misc.LINE_SEPARATOR + "\t - you did not logged in (e.g. using: " + LoginContext.class.getName() + ".login()" + Misc.LINE_SEPARATOR + "\t - your JAAS configuration did not fill the Subject with a: " + JMXPrincipal.class.getName() + " (See your JAAS login module in your JAAS configuration file)" + Misc.LINE_SEPARATOR + "\t - method " + SecurityContext.class.getName() + ".setSubject() has not been called" + " (e.g. stack " + StorageLoginModule.class.getName() + " as the last LoginModule in your JAAS config file)";
    private static final InheritableThreadLocal<Subject> SUBJECTS = new InheritableThreadLocal();
    private static final Logger LOG = Logger.getLogger(SecurityContext.class.getName());
    private static final Principal[] TYPE_CACHE = new Principal[0];

    private SecurityContext() {
    }

    public static Subject getSubject() {
        Subject subject;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(SecurityContext.class.getName(), "getSubject");
        }
        if ((subject = (Subject)SUBJECTS.get()) == null) {
            throw new IllegalStateException(HELP);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(SecurityContext.class.getName(), "getSubject", subject);
        }
        return subject;
    }

    static void setSubject(Subject subject) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(SecurityContext.class.getName(), "setSubject", subject);
        }
        if (subject == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bi_SC_1", new Object[0]);
            throw new IllegalStateException(message);
        }
        Subject current = (Subject)SUBJECTS.get();
        if (current != null && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Subject is already set to: " + current + ". Did you logout before login?");
        }
        SUBJECTS.set(subject);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subject set: " + subject);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(SecurityContext.class.getName(), "setSubject");
        }
    }

    static void clearSubject() {
        Subject subject;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.entering(SecurityContext.class.getName(), "clearSubject");
        }
        if ((subject = (Subject)SUBJECTS.get()) == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("clearSubject() called but subject is already null!");
            }
        } else {
            SUBJECTS.remove();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Subject cleared");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.exiting(SecurityContext.class.getName(), "clearSubject");
        }
    }

    public static String getCallerId() {
        Subject subject = SecurityContext.getSubject();
        Set<Principal> principals = subject.getPrincipals();
        if (principals == null || principals.size() == 0) {
            String message = ExceptionManager.getInstance().getFullMessage("bi_SC_2", subject);
            throw new RuntimeException(message);
        }
        Principal principal = principals.toArray(TYPE_CACHE)[0];
        if (principals.size() > 1 && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sereveral principals were found in subject. First is considered the callerId. Subject is: " + subject);
        }
        return principal.getName();
    }
}

