/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.light.impl;

import java.util.Date;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.impl.RuntimeRecordImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightActivityInstance;
import org.ow2.bonita.light.LightTaskInstance;
import org.ow2.bonita.util.Misc;

public class LightActivityInstanceImpl
extends RuntimeRecordImpl
implements LightActivityInstance,
LightTaskInstance {
    private static final long serialVersionUID = -8515098234372896097L;
    protected ActivityInstanceUUID uuid;
    protected String iterationId;
    protected String activityInstanceId;
    protected ActivityState state;
    protected String userId;
    protected long lastUpdate;
    protected String label;
    protected String description;
    protected String dynamicLabel;
    protected String dynamicDescription;
    protected String name;
    protected long startedDate;
    protected long endedDate;
    protected long readyDate;
    protected String endedBy;
    protected String startedBy;
    protected ActivityDefinitionUUID activityDefinitionUUID;
    protected long expectedEndDate;
    protected int priority;
    protected ActivityDefinition.Type type;
    protected ProcessInstanceUUID subflowProcessInstanceUUID;
    protected boolean human = false;

    protected LightActivityInstanceImpl() {
    }

    public LightActivityInstanceImpl(ActivityInstanceUUID uuid, ActivityDefinition activityDefinition, ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ProcessInstanceUUID rootInstanceUUID, String iterationId, String activityInstanceId) {
        super(processUUID, instanceUUID, rootInstanceUUID);
        Misc.checkArgsNotNull(uuid, activityDefinition);
        this.uuid = uuid;
        this.iterationId = iterationId;
        this.activityInstanceId = activityInstanceId;
        this.state = ActivityState.READY;
        this.lastUpdate = System.currentTimeMillis();
        this.activityDefinitionUUID = activityDefinition.getUUID();
        this.priority = activityDefinition.getPriority();
        this.type = activityDefinition.getType();
        this.name = activityDefinition.getName();
        this.description = activityDefinition.getDescription();
        this.label = activityDefinition.getLabel();
        this.human = this.isTask();
        long executingTime = activityDefinition.getExecutingTime();
        if (executingTime > 0L) {
            this.expectedEndDate = System.currentTimeMillis() + executingTime;
        }
    }

    public LightActivityInstanceImpl(ActivityInstance src) {
        super(src);
        this.uuid = new ActivityInstanceUUID(src.getUUID());
        this.iterationId = src.getIterationId();
        this.activityInstanceId = src.getActivityInstanceId();
        this.lastUpdate = Misc.getTime(src.getLastUpdateDate());
        this.startedDate = Misc.getTime(src.getStartedDate());
        this.endedDate = Misc.getTime(src.getEndedDate());
        this.expectedEndDate = Misc.getTime(src.getExpectedEndDate());
        this.readyDate = Misc.getTime(src.getReadyDate());
        this.activityDefinitionUUID = new ActivityDefinitionUUID(src.getActivityDefinitionUUID());
        if (src.getSubflowProcessInstanceUUID() != null) {
            this.subflowProcessInstanceUUID = new ProcessInstanceUUID(src.getSubflowProcessInstanceUUID());
        }
        this.priority = src.getPriority();
        this.type = src.getType();
        this.name = src.getActivityName();
        this.description = src.getActivityDescription();
        this.label = src.getActivityLabel();
        this.dynamicDescription = src.getDynamicDescription();
        this.dynamicLabel = src.getDynamicLabel();
        if (src.isTask()) {
            TaskInstance task = src.getTask();
            this.human = true;
            this.startedBy = task.getStartedBy();
            this.endedBy = task.getEndedBy();
            this.userId = task.getTaskUser();
        }
        this.state = src.getState();
    }

    public String getActivityLabel() {
        return this.label;
    }

    public String getActivityDescription() {
        return this.description;
    }

    public String getDynamicDescription() {
        return this.dynamicDescription;
    }

    public String getDynamicLabel() {
        return this.dynamicLabel;
    }

    public String toString() {
        String userId;
        try {
            userId = this.getTaskUser();
        }
        catch (IllegalStateException e) {
            userId = null;
        }
        String st = this.getClass().getName() + "[uuid: " + this.getUUID() + ", activityId: " + this.getActivityName() + ", iterationId: " + this.getIterationId() + ", processDefinitionUUID: " + this.getProcessDefinitionUUID() + ", processUUID: " + this.getProcessInstanceUUID() + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + ", readyDate: " + this.getReadyDate() + ", userId: " + userId + ", state: " + (Object)((Object)this.getState()) + ", createdDate: " + this.getCreatedDate() + ", startedBy: " + this.getStartedBy() + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + ", endedBy: " + this.getEndedBy() + "]";
        return st;
    }

    public LightTaskInstance getTask() {
        if (this.isTask()) {
            return this;
        }
        return null;
    }

    public String getIterationId() {
        return this.iterationId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public String getActivityName() {
        return this.name;
    }

    public ActivityInstanceUUID getUUID() {
        return this.uuid;
    }

    public Date getStartedDate() {
        return Misc.getDate(this.startedDate);
    }

    public Date getEndedDate() {
        return Misc.getDate(this.endedDate);
    }

    public Date getReadyDate() {
        return Misc.getDate(this.readyDate);
    }

    public Date getCreatedDate() {
        return this.getReadyDate();
    }

    public String getEndedBy() {
        return this.endedBy;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public ActivityState getState() {
        return this.state;
    }

    public String getTaskUser() {
        return this.userId;
    }

    public boolean isTaskAssigned() {
        return this.userId != null;
    }

    public Date getLastUpdateDate() {
        return Misc.getDate(this.lastUpdate);
    }

    public ActivityDefinitionUUID getActivityDefinitionUUID() {
        return this.activityDefinitionUUID;
    }

    public int getPriority() {
        return this.priority;
    }

    public Date getExpectedEndDate() {
        return Misc.getDate(this.expectedEndDate);
    }

    public ProcessInstanceUUID getSubflowProcessInstanceUUID() {
        return this.subflowProcessInstanceUUID;
    }

    public boolean isAutomatic() {
        return ActivityDefinition.Type.Automatic.equals((Object)this.getType());
    }

    public boolean isSubflow() {
        return ActivityDefinition.Type.Subflow.equals((Object)this.getType());
    }

    public boolean isTimer() {
        return ActivityDefinition.Type.Timer.equals((Object)this.getType());
    }

    public boolean isTask() {
        return ActivityDefinition.Type.Human.equals((Object)this.getType());
    }

    public ActivityDefinition.Type getType() {
        return this.type;
    }
}

