/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.light.impl;

import java.util.Date;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.NamedElementImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.util.Misc;

public class LightProcessDefinitionImpl
extends NamedElementImpl
implements LightProcessDefinition {
    private static final long serialVersionUID = -572795239631090498L;
    protected ProcessDefinitionUUID uuid;
    protected String version;
    protected ProcessDefinition.ProcessState state;
    protected long deployedDate;
    protected long undeployedDate;
    protected String deployedBy;
    protected String undeployedBy;

    protected LightProcessDefinitionImpl() {
    }

    public LightProcessDefinitionImpl(ProcessDefinition src) {
        super(src);
        this.uuid = new ProcessDefinitionUUID(src.getUUID());
        this.state = src.getState();
        this.version = src.getVersion();
        this.deployedDate = Misc.getTime(src.getDeployedDate());
        this.undeployedDate = Misc.getTime(src.getUndeployedDate());
        this.deployedBy = src.getDeployedBy();
        this.undeployedBy = src.getUndeployedBy();
    }

    protected LightProcessDefinitionImpl(String name, String version) {
        super(name);
        Misc.checkArgsNotNull(name, version);
        this.version = version;
        if (this.version == null) {
            this.version = "1.0";
        }
        this.uuid = new ProcessDefinitionUUID(name, version);
    }

    public String toString() {
        String st = this.getClass().getName() + "[uuid: " + this.getUUID() + ", name:" + this.getName() + ", description:" + this.getDescription() + ", version:" + this.getVersion();
        st = st + "]";
        return st;
    }

    public ProcessDefinition.ProcessState getState() {
        return this.state;
    }

    public String getVersion() {
        return this.version;
    }

    public ProcessDefinitionUUID getUUID() {
        return this.uuid;
    }

    public Date getDeployedDate() {
        return Misc.getDate(this.deployedDate);
    }

    public String getDeployedBy() {
        return this.deployedBy;
    }

    public Date getUndeployedDate() {
        return Misc.getDate(this.undeployedDate);
    }

    public String getUndeployedBy() {
        return this.undeployedBy;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ProcessDefinitionImpl other = (ProcessDefinitionImpl)obj;
        return other.getUUID().equals(this.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

