/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.light.impl;

import java.util.Date;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.impl.RuntimeRecordImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Misc;

public class LightProcessInstanceImpl
extends RuntimeRecordImpl
implements LightProcessInstance {
    private static final long serialVersionUID = 8366284714927360659L;
    protected ProcessInstanceUUID parentInstanceUUID;
    protected long nb;
    protected long lastUpdate;
    protected InstanceState state;
    protected String endedBy;
    protected long endedDate;
    protected String startedBy;
    protected long startedDate;

    public String toString() {
        return this.getClass().getName() + "[uuid: " + this.getUUID() + ", processDefinitionUUID: " + this.getProcessDefinitionUUID() + ", processUUID: " + this.getProcessInstanceUUID() + ", parentInstanceUUID: " + this.getParentInstanceUUID() + ", startedBy: " + this.getStartedBy() + ", endedBy: " + this.getEndedBy() + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + ", rootInstanceUUID: " + this.getRootInstanceUUID() + "]";
    }

    protected LightProcessInstanceImpl() {
    }

    public LightProcessInstanceImpl(ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ProcessInstanceUUID rootInstanceUUID) {
        super(processUUID, instanceUUID, rootInstanceUUID);
        this.nb = instanceUUID.getInstanceNb();
        this.state = InstanceState.STARTED;
        this.lastUpdate = System.currentTimeMillis();
    }

    public LightProcessInstanceImpl(ProcessInstance processInstance) {
        super(processInstance);
        if (processInstance.getParentInstanceUUID() != null) {
            this.parentInstanceUUID = new ProcessInstanceUUID(processInstance.getParentInstanceUUID());
        }
        this.nb = processInstance.getNb();
        this.lastUpdate = Misc.getTime(processInstance.getLastUpdate());
        this.state = processInstance.getInstanceState();
        this.endedBy = processInstance.getEndedBy();
        this.endedDate = Misc.getTime(processInstance.getEndedDate());
        this.startedBy = processInstance.getStartedBy();
        this.startedDate = Misc.getTime(processInstance.getStartedDate());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        LightProcessInstanceImpl other = (LightProcessInstanceImpl)obj;
        if (other.getUUID() == null) {
            return this.getUUID() == null;
        }
        return other.getUUID().equals(this.getUUID());
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    public String getEndedBy() {
        return this.endedBy;
    }

    public Date getEndedDate() {
        return Misc.getDate(this.endedDate);
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public Date getStartedDate() {
        return Misc.getDate(this.startedDate);
    }

    public InstanceState getInstanceState() {
        return this.state;
    }

    public ProcessInstanceUUID getParentInstanceUUID() {
        return this.parentInstanceUUID;
    }

    public ProcessInstanceUUID getUUID() {
        return this.getProcessInstanceUUID();
    }

    public Date getLastUpdate() {
        return Misc.getDate(this.lastUpdate);
    }

    public long getNb() {
        return this.nb;
    }

    public ProcessInstanceUUID getRootInstanceUUID() {
        return this.rootInstanceUUID;
    }
}

