/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.connector.binding;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.connector.core.desc.ConnectorDescriptor;
import org.ow2.bonita.connector.core.desc.Setter;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class SetterBinding
extends ElementBinding {
    private static Set<String> allowedParameters = new HashSet<String>();

    public SetterBinding() {
        super("setter");
    }

    public Object parse(Element setterElement, Parse parse, Parser parser) {
        ConnectorDescriptor descriptor = parse.findObject(ConnectorDescriptor.class);
        String setterName = this.getChildTextContent(setterElement, "setterName");
        String required = this.getChildTextContent(setterElement, "required");
        String forbidden = this.getChildTextContent(setterElement, "forbidden");
        Object[] parameters = this.getParameters(setterElement);
        Setter setter = new Setter(setterName, required, forbidden, parameters);
        descriptor.addSetter(setter);
        return null;
    }

    private Object[] getParameters(Element setter) {
        Element parametersElement = XmlUtil.element(setter, "parameters");
        if (parametersElement != null) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            List<Element> elements = XmlUtil.elements(parametersElement, allowedParameters);
            for (Element element : elements) {
                parameters.add(this.getParameter(element));
            }
            return parameters.toArray();
        }
        return null;
    }

    private Object getParameter(Element parameter) {
        String parameterType = parameter.getNodeName();
        String parameterValue = parameter.getTextContent().trim();
        if ("int".equals(parameterType)) {
            return Integer.parseInt(parameterValue);
        }
        if ("double".equals(parameterType)) {
            return Double.parseDouble(parameterValue);
        }
        if ("string".equals(parameterType)) {
            return parameterValue;
        }
        if ("boolean".equals(parameterType)) {
            return Boolean.parseBoolean(parameterValue);
        }
        if ("long".equals(parameterType)) {
            return Long.parseLong(parameterValue);
        }
        if ("float".equals(parameterType)) {
            return new Float(parameterValue);
        }
        if ("short".equals(parameterType)) {
            return new Short(parameterValue);
        }
        if ("map".equals(parameterType)) {
            return new HashMap();
        }
        if ("list".equals(parameterType)) {
            return new ArrayList();
        }
        if ("object".equals(parameterType)) {
            return new Object();
        }
        if ("date".equals(parameterType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            try {
                return format.parse(parameterValue);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        throw new BonitaRuntimeException(parameterType);
    }

    static {
        allowedParameters.add("date");
        allowedParameters.add("string");
        allowedParameters.add("int");
        allowedParameters.add("double");
        allowedParameters.add("float");
        allowedParameters.add("long");
        allowedParameters.add("short");
        allowedParameters.add("boolean");
        allowedParameters.add("list");
        allowedParameters.add("map");
        allowedParameters.add("object");
    }
}

