/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ActivityBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(ActivityBinding.class.getName());

    public ActivityBinding() {
        super("activity");
    }

    public Object parse(Element activityElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + activityElement);
        }
        String name = null;
        try {
            String executingTime;
            String priority;
            ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
            name = XmlUtil.attribute(activityElement, "name");
            String description = this.getChildTextContent(activityElement, "description");
            String label = this.getChildTextContent(activityElement, "label");
            String dynamicDescription = this.getChildTextContent(activityElement, "dynamic-description");
            String dynamicLabel = this.getChildTextContent(activityElement, "dynamic-label");
            ActivityDefinition.SplitType splitType = this.getEnumValue(ActivityDefinition.SplitType.class, this.getChildTextContent(activityElement, "split-type"), ActivityDefinition.SplitType.AND);
            ActivityDefinition.JoinType joinType = this.getEnumValue(ActivityDefinition.JoinType.class, this.getChildTextContent(activityElement, "join-type"), ActivityDefinition.JoinType.XOR);
            ActivityDefinition.Type type = this.getEnumValue(ActivityDefinition.Type.class, this.getChildTextContent(activityElement, "type"), ActivityDefinition.Type.Automatic);
            String asynchronous = this.getChildTextContent(activityElement, "asynchronous");
            String loopCondition = this.getChildTextContent(activityElement, "loop-condition");
            String loopMaximum = this.getChildTextContent(activityElement, "loop-maximum");
            String beforeExecution = this.getChildTextContent(activityElement, "before-execution");
            Boolean isReceiveEventActivity = Boolean.FALSE;
            if (ActivityDefinition.Type.Automatic.equals((Object)type)) {
                processBuilder.addSystemTask(name);
            } else if (ActivityDefinition.Type.Human.equals((Object)type)) {
                Element performersElement = XmlUtil.element(activityElement, "performers");
                List<Element> performerElements = XmlUtil.elements(performersElement, "performer");
                if (performerElements != null) {
                    String[] performers = new String[performerElements.size()];
                    for (int i = 0; i < performerElements.size(); ++i) {
                        performers[i] = performerElements.get(i).getTextContent();
                    }
                    processBuilder.addHumanTask(name, performers);
                } else {
                    processBuilder.addHumanTask(name, new String[0]);
                }
            } else if (ActivityDefinition.Type.ReceiveEvent.equals((Object)type)) {
                isReceiveEventActivity = Boolean.TRUE;
                Element incommingEventElement = XmlUtil.element(activityElement, "incoming-event");
                String incommingEventName = XmlUtil.attribute(incommingEventElement, "name");
                String incommingEventExpression = this.getChildTextContent(incommingEventElement, "expression");
                processBuilder.addReceiveEventTask(name, incommingEventName, incommingEventExpression);
            } else if (ActivityDefinition.Type.SendEvents.equals((Object)type)) {
                processBuilder.addSendEventTask(name);
                Element outgoingEventsParametersElement = XmlUtil.element(activityElement, "outgoing-events");
                List<Element> outgoingEventElements = XmlUtil.elements(outgoingEventsParametersElement, "outgoing-event");
                if (outgoingEventElements != null) {
                    for (Element outgoingEventElement : outgoingEventElements) {
                        String outgoingEventTimeToLive;
                        String outgoingEventName = XmlUtil.attribute(outgoingEventElement, "name");
                        String outgoingEventToActivityName = this.getChildTextContent(outgoingEventElement, "to-activity");
                        String outgoingEventToProcessName = this.getChildTextContent(outgoingEventElement, "to-process");
                        Element outgoingEventParametersElement = XmlUtil.element(outgoingEventElement, "parameters");
                        List<Element> outgoingEventParameterElements = XmlUtil.elements(outgoingEventParametersElement, "parameter");
                        HashMap<String, Object> outgoingEventParameters = new HashMap<String, Object>();
                        if (outgoingEventParameterElements != null) {
                            for (Element outgoingEventparameterElement : outgoingEventParameterElements) {
                                try {
                                    outgoingEventParameters.put(outgoingEventparameterElement.getAttribute("name"), Misc.deserialize(this.decodeAndGather(outgoingEventparameterElement.getTextContent())));
                                }
                                catch (Exception e) {
                                    throw new BonitaRuntimeException("Error while deserializing", e);
                                }
                            }
                        }
                        if ((outgoingEventTimeToLive = this.getChildTextContent(outgoingEventElement, "time-to-live")) != null) {
                            processBuilder.addOutgoingEvent(outgoingEventName, outgoingEventToProcessName, outgoingEventToActivityName, Long.parseLong(outgoingEventTimeToLive), outgoingEventParameters);
                            continue;
                        }
                        processBuilder.addOutgoingEvent(outgoingEventName, outgoingEventToProcessName, outgoingEventToActivityName, outgoingEventParameters);
                    }
                }
            } else if (ActivityDefinition.Type.Timer.equals((Object)type)) {
                String timerCondition = this.getChildTextContent(activityElement, "timer-condition");
                processBuilder.addTimerTask(name, timerCondition);
            } else if (ActivityDefinition.Type.Subflow.equals((Object)type)) {
                Element subProcessOutParametersElement;
                List<Element> subProcessOutParameterElements;
                String subflowProcessName = this.getChildTextContent(activityElement, "subflow-process-name");
                String subflowProcessVersion = this.getChildTextContent(activityElement, "subflow-process-version");
                processBuilder.addSubProcess(name, subflowProcessName, subflowProcessVersion);
                Element subProcessInParametersElement = XmlUtil.element(activityElement, "subflow-in-parameters");
                List<Element> subProcessInParameterElements = XmlUtil.elements(subProcessInParametersElement, "subflow-in-parameter");
                if (subProcessInParameterElements != null) {
                    for (Element subProcessInParameterElement : subProcessInParameterElements) {
                        String parentProcessDatafieldName = this.getChildTextContent(subProcessInParameterElement, "source");
                        String subProcessDatafieldName = this.getChildTextContent(subProcessInParameterElement, "destination");
                        processBuilder.addSubProcessInParameter(parentProcessDatafieldName, subProcessDatafieldName);
                    }
                }
                if ((subProcessOutParameterElements = XmlUtil.elements(subProcessOutParametersElement = XmlUtil.element(activityElement, "subflow-out-parameters"), "subflow-out-parameter")) != null) {
                    for (Element subProcessOutParameterElement : subProcessOutParameterElements) {
                        String subProcessDatafieldName = this.getChildTextContent(subProcessOutParameterElement, "source");
                        String parentProcessDatafieldName = this.getChildTextContent(subProcessOutParameterElement, "destination");
                        processBuilder.addSubProcessOutParameter(subProcessDatafieldName, parentProcessDatafieldName);
                    }
                }
            } else if (ActivityDefinition.Type.Decision.equals((Object)type)) {
                processBuilder.addDecisionNode(name);
            } else {
                parse.addProblem("unsupported activity type : " + (Object)((Object)type));
            }
            processBuilder.addLabel(label);
            processBuilder.addDescription(description);
            processBuilder.addDynamicLabel(dynamicLabel);
            processBuilder.addDynamicDescription(dynamicDescription);
            processBuilder.addSplitType(splitType);
            processBuilder.addJoinType(joinType);
            if (loopCondition != null && beforeExecution != null) {
                processBuilder.addLoop(loopCondition, Boolean.parseBoolean(beforeExecution), loopMaximum);
            }
            if (Boolean.parseBoolean(asynchronous)) {
                processBuilder.asynchronous();
            }
            if ((priority = this.getChildTextContent(activityElement, "priority")) != null && priority.length() > 0) {
                processBuilder.addActivityPriority(Integer.parseInt(priority));
            }
            if ((executingTime = this.getChildTextContent(activityElement, "executing-time")) != null && Long.parseLong(executingTime) > 0L) {
                processBuilder.addActivityExecutingTime(Long.parseLong(executingTime));
            }
            this.parseMultiInstantiation(activityElement, processBuilder);
            this.parseMultipleActivitiesInstantiator(activityElement, processBuilder);
            this.parseMultipleActivitiesJoinChecker(activityElement, processBuilder);
            this.parseFilter(activityElement, processBuilder);
            this.parseDeadlines(activityElement, processBuilder);
            this.parseElementList(activityElement, "data-fields", "data-field", parse, parser);
            parse.pushObject(isReceiveEventActivity);
            this.parseElementList(activityElement, "connectors", "connector", parse, parser);
            parse.popObject();
        }
        catch (Exception e) {
            parse.addProblem("Error parsing Activity " + name, e);
        }
        return null;
    }

    private void parseMultiInstantiation(Element activityElement, ProcessBuilder processBuilder) {
        Element multiInstantiationElement = XmlUtil.element(activityElement, "multi-instantiation");
        if (multiInstantiationElement != null && XmlUtil.elements(multiInstantiationElement) != null && !XmlUtil.elements(multiInstantiationElement).isEmpty()) {
            String multiInstantiationClassName = this.getChildTextContent(multiInstantiationElement, "classname");
            String multiInstantiationVariableName = this.getChildTextContent(multiInstantiationElement, "variable-name");
            processBuilder.addMultiInstanciation(multiInstantiationVariableName, multiInstantiationClassName);
            Element multiInstantiationParametersElement = XmlUtil.element(multiInstantiationElement, "parameters");
            List<Element> multiInstantiationParameterElements = XmlUtil.elements(multiInstantiationParametersElement, "parameter");
            if (multiInstantiationParameterElements != null) {
                for (Element multiInstantiationParameterElement : multiInstantiationParameterElements) {
                    try {
                        processBuilder.addInputParameter(multiInstantiationParameterElement.getAttribute("name"), (Object[])Misc.deserialize(this.decodeAndGather(multiInstantiationParameterElement.getTextContent())));
                    }
                    catch (Exception e) {
                        throw new BonitaRuntimeException("Error while deserializing", e);
                    }
                }
            }
        }
    }

    private void parseMultipleActivitiesInstantiator(Element activityElement, ProcessBuilder processBuilder) {
        Element instantiatorElement = XmlUtil.element(activityElement, "multiple-act-instantiator");
        if (instantiatorElement != null && XmlUtil.element(instantiatorElement) != null) {
            List<Element> instantiatorParametersElements;
            String instantiatorClassName = this.getChildTextContent(instantiatorElement, "classname");
            processBuilder.addMultipleActivitiesInstantiator(instantiatorClassName);
            Element instantiatorParametersElement = XmlUtil.element(instantiatorElement, "parameters");
            if (instantiatorParametersElement != null && (instantiatorParametersElements = XmlUtil.elements(instantiatorParametersElement, "parameter")) != null) {
                for (Element instantiatorParameterElement : instantiatorParametersElements) {
                    try {
                        String key = instantiatorParameterElement.getAttribute("name");
                        processBuilder.addInputParameter(key, (Object[])Misc.deserialize(this.decodeAndGather(instantiatorParameterElement.getTextContent())));
                    }
                    catch (Exception e) {
                        throw new BonitaRuntimeException("Error while deserializing", e);
                    }
                }
            }
        }
    }

    private void parseMultipleActivitiesJoinChecker(Element activityElement, ProcessBuilder processBuilder) {
        Element joinCheckerElement = XmlUtil.element(activityElement, "multiple-act-joinchecker");
        if (joinCheckerElement != null && XmlUtil.element(joinCheckerElement) != null) {
            List<Element> joinCheckerParametersElements;
            String joinCheckerClassName = this.getChildTextContent(joinCheckerElement, "classname");
            processBuilder.addMultipleActivitiesJoinChecker(joinCheckerClassName);
            Element joinCheckerParametersElement = XmlUtil.element(joinCheckerElement, "parameters");
            if (joinCheckerParametersElement != null && (joinCheckerParametersElements = XmlUtil.elements(joinCheckerParametersElement, "parameter")) != null) {
                for (Element joinCheckerParameterElement : joinCheckerParametersElements) {
                    try {
                        String key = joinCheckerParameterElement.getAttribute("name");
                        processBuilder.addInputParameter(key, (Object[])Misc.deserialize(this.decodeAndGather(joinCheckerParameterElement.getTextContent())));
                    }
                    catch (Exception e) {
                        throw new BonitaRuntimeException("Error while deserializing", e);
                    }
                }
            }
        }
    }

    private void parseFilter(Element activityElement, ProcessBuilder processBuilder) {
        Element filterElement = XmlUtil.element(activityElement, "filter");
        if (filterElement != null && XmlUtil.elements(filterElement) != null && !XmlUtil.elements(filterElement).isEmpty()) {
            String filterClassName = this.getChildTextContent(filterElement, "classname");
            String filterDescription = this.getChildTextContent(filterElement, "description");
            processBuilder.addFilter(filterClassName);
            processBuilder.addDescription(filterDescription);
            Element filterParametersElement = XmlUtil.element(filterElement, "parameters");
            List<Element> filterParameterElements = XmlUtil.elements(filterParametersElement, "parameter");
            if (filterParameterElements != null) {
                for (Element filterParameterElement : filterParameterElements) {
                    try {
                        processBuilder.addInputParameter(filterParameterElement.getAttribute("name"), (Object[])Misc.deserialize(this.decodeAndGather(filterParameterElement.getTextContent())));
                    }
                    catch (Exception e) {
                        throw new BonitaRuntimeException("Error while deserializing", e);
                    }
                }
            }
        }
    }

    private void parseDeadlines(Element activityElement, ProcessBuilder processBuilder) {
        Element deadlinesElement = XmlUtil.element(activityElement, "deadlines");
        List<Element> deadlineElements = XmlUtil.elements(deadlinesElement, "deadline");
        if (deadlineElements != null) {
            for (Element deadlineElement : deadlineElements) {
                String condition = this.getChildTextContent(deadlineElement, "condition");
                String connectorClassName = this.getChildTextContent(deadlineElement, "classname");
                String deadlineDescription = this.getChildTextContent(deadlineElement, "description");
                processBuilder.addDeadline(condition, connectorClassName);
                processBuilder.addDescription(deadlineDescription);
                Element deadlineParametersElement = XmlUtil.element(deadlineElement, "parameters");
                List<Element> deadlineParameterElements = XmlUtil.elements(deadlineParametersElement, "parameter");
                if (deadlineParameterElements == null) continue;
                for (Element deadlineParameterElement : deadlineParameterElements) {
                    try {
                        String key = deadlineParameterElement.getAttribute("name");
                        if (Misc.isSetter(key)) {
                            processBuilder.addInputParameter(key, (Object[])Misc.deserialize(this.decodeAndGather(deadlineParameterElement.getTextContent())));
                            continue;
                        }
                        processBuilder.addOutputParameter(((Object[])Misc.deserialize(this.decodeAndGather(deadlineParameterElement.getTextContent())))[0].toString(), key);
                    }
                    catch (Exception e) {
                        throw new BonitaRuntimeException("Error while deserializing", e);
                    }
                }
            }
        }
    }
}

