/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ConnectorBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(ConnectorBinding.class.getName());

    public ConnectorBinding() {
        super("connector");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object parse(Element connectorElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + connectorElement);
        }
        String className = null;
        try {
            ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
            Boolean isReceiveEventActivity = parse.findObject(Boolean.class);
            className = this.getChildTextContent(connectorElement, "classname");
            HookDefinition.Event event = this.getEnumValue(HookDefinition.Event.class, this.getChildTextContent(connectorElement, "event"), HookDefinition.Event.instanceOnStart);
            String description = this.getChildTextContent(connectorElement, "description");
            String throwingException = this.getChildTextContent(connectorElement, "throw-exception");
            if (isReceiveEventActivity != null && isReceiveEventActivity.booleanValue()) {
                processBuilder.addReceiveEventConnector(className, Boolean.parseBoolean(throwingException));
            } else {
                processBuilder.addConnector(event, className, Boolean.parseBoolean(throwingException));
            }
            processBuilder.addDescription(description);
            Element connectorParametersElement = XmlUtil.element(connectorElement, "parameters");
            List<Element> connectorParameterElements = XmlUtil.elements(connectorParametersElement, "parameter");
            if (connectorParameterElements == null) return null;
            for (Element connectorParameterElement : connectorParameterElements) {
                try {
                    String key = connectorParameterElement.getAttribute("name");
                    if (Misc.isSetter(key)) {
                        processBuilder.addInputParameter(key, (Object[])Misc.deserialize(this.decodeAndGather(connectorParameterElement.getTextContent())));
                        continue;
                    }
                    processBuilder.addOutputParameter(((Object[])Misc.deserialize(this.decodeAndGather(connectorParameterElement.getTextContent())))[0].toString(), key);
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException("Error while deserializing", e);
                    return null;
                }
            }
        }
        catch (Exception e) {
            parse.addProblem("Error parsing Connector " + className, e);
        }
        return null;
    }
}

