/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ProcessBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(ProcessBinding.class.getName());

    public ProcessBinding() {
        super("process");
    }

    public Object parse(Element processElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + processElement);
        }
        String name = null;
        try {
            name = XmlUtil.attribute(processElement, "name");
            String version = XmlUtil.attribute(processElement, "version");
            String description = this.getChildTextContent(processElement, "description");
            String label = this.getChildTextContent(processElement, "label");
            ProcessBuilder processBuilder = ProcessBuilder.createProcess(name, version);
            processBuilder.addDescription(description);
            processBuilder.addLabel(label);
            parse.pushObject(processBuilder);
            this.parseElementList(processElement, "participants", "participant", parse, parser);
            this.parseElementList(processElement, "data-fields", "data-field", parse, parser);
            this.parseElementList(processElement, "attachments", "attachment", parse, parser);
            this.parseElementList(processElement, "connectors", "connector", parse, parser);
            this.parseElementList(processElement, "activities", "activity", parse, parser);
            this.parseElementList(processElement, "transitions", "transition", parse, parser);
            parse.popObject();
            return processBuilder.done();
        }
        catch (Exception e) {
            parse.addProblem("Error parsing Process " + name, e);
            return null;
        }
    }
}

