/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class TransitionBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(TransitionBinding.class.getName());

    public TransitionBinding() {
        super("transition");
    }

    public Object parse(Element transitionElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + transitionElement);
        }
        String name = null;
        try {
            boolean isDefaultValue;
            ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
            name = XmlUtil.attribute(transitionElement, "name");
            String label = this.getChildTextContent(transitionElement, "label");
            String description = this.getChildTextContent(transitionElement, "description");
            String from = this.getChildTextContent(transitionElement, "from");
            String to = this.getChildTextContent(transitionElement, "to");
            String condition = this.getChildTextContent(transitionElement, "condition");
            String isDefault = this.getChildTextContent(transitionElement, "is-default");
            processBuilder.addTransition(name, from, to);
            processBuilder.addDescription(description);
            processBuilder.addLabel(label);
            if (condition != null && condition.length() > 0) {
                processBuilder.addCondition(condition);
            }
            if (isDefault != null && (isDefaultValue = Boolean.parseBoolean(isDefault))) {
                processBuilder.setDefault();
            }
        }
        catch (Exception e) {
            parse.addProblem("Error parsing Transition " + name, e);
        }
        return null;
    }
}

