/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.xpdl.binding;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.xpdl.binding.MajorElementBinding;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class TransitionBinding
extends MajorElementBinding {
    private static final Logger LOG = Logger.getLogger(TransitionBinding.class.getName());

    public TransitionBinding() {
        super("Transition");
    }

    public Object parse(Element transitionElement, Parse parse, Parser parser) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("parsing element = " + transitionElement);
        }
        String id = this.getId(transitionElement);
        String description = this.getChildTextContent(transitionElement, "Description");
        String from = XmlUtil.attribute(transitionElement, "From");
        String to = XmlUtil.attribute(transitionElement, "To");
        ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
        processBuilder.addTransition(id, from, to);
        processBuilder.addDescription(description);
        processBuilder.addLabel(XmlUtil.attribute(transitionElement, "Name"));
        Element conditionElement = XmlUtil.element(transitionElement, "Condition");
        if (conditionElement != null) {
            String contentAsString = conditionElement.getTextContent();
            List<Element> xpressionElements = XmlUtil.elements(conditionElement, "Xpression");
            if (xpressionElements != null && !xpressionElements.isEmpty()) {
                parse.addProblem("Element Xpression not supported on Condition element");
            }
            processBuilder.addCondition(contentAsString);
        }
        return null;
    }
}

