/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.xpdl.binding;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.xpdl.binding.MajorElementBinding;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class WorkflowProcessBinding
extends MajorElementBinding {
    private static final Logger LOG = Logger.getLogger(WorkflowProcessBinding.class.getName());

    public WorkflowProcessBinding() {
        super("WorkflowProcess");
    }

    public Object parse(Element workflowProcessElement, Parse parse, Parser parser) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("parsing element = " + workflowProcessElement);
        }
        String id = this.getId(workflowProcessElement);
        Element processHeaderElement = XmlUtil.element(workflowProcessElement, "ProcessHeader");
        String description = this.getChildTextContent(processHeaderElement, "Description");
        Element redefinableHeaderElement = XmlUtil.element(workflowProcessElement, "RedefinableHeader");
        String version = this.getChildTextContent(redefinableHeaderElement, "Version");
        if (version == null) {
            Element packageElement = (Element)workflowProcessElement.getParentNode().getParentNode();
            Element packageRedefinableHeaderElement = XmlUtil.element(packageElement, "RedefinableHeader");
            version = this.getChildTextContent(packageRedefinableHeaderElement, "Version");
        }
        ProcessBuilder processBuilder = ProcessBuilder.createProcess(id, version);
        processBuilder.addDescription(description);
        processBuilder.addLabel(XmlUtil.attribute(workflowProcessElement, "Name"));
        parse.pushObject(processBuilder);
        this.parseFormalParameters(workflowProcessElement, parse, parser, processBuilder);
        this.parseXpdlMajorElementList(workflowProcessElement, "Participants", "Participant", parse, parser);
        Collection<Element> activityDatafields = this.parseXpdlMajorElementList(workflowProcessElement, "DataFields", "DataField", parse, parser);
        parse.pushObject(activityDatafields);
        parse.pushObject(new Boolean(true));
        this.parseXpdlMajorElementList(workflowProcessElement, "Activities", "Activity", parse, parser);
        parse.popObject();
        parse.popObject();
        this.parseXpdlMajorElementList(workflowProcessElement, "Transitions", "Transition", parse, parser);
        parse.popObject();
        this.parseIterationElements(workflowProcessElement, processBuilder);
        return processBuilder.done();
    }

    private void parseIterationElements(Element workflowProcessElement, ProcessBuilder processBuilder) {
        Element activities = XmlUtil.element(workflowProcessElement, "Activities");
        if (activities != null) {
            for (Element activity : XmlUtil.elements(activities, "Activity")) {
                Set<Element> iterationElements = this.getExtendedAttributes(activity, "Iteration");
                if (iterationElements == null) continue;
                for (Element iterationElement : iterationElements) {
                    String iterationCondition = XmlUtil.attribute(iterationElement, "Value");
                    String iterationTo = this.getChildTextContent(iterationElement, "To");
                    String activityName = this.getId(activity);
                    processBuilder.addTransition(activityName + "_" + iterationTo, activityName, iterationTo);
                    processBuilder.addCondition(iterationCondition);
                }
            }
        }
    }

    protected void parseFormalParameters(Element fatherElement, Parse parse, Parser parser, ProcessBuilder processBuilder) {
        Element formalParametersElement = XmlUtil.element(fatherElement, "FormalParameters");
        if (formalParametersElement != null) {
            parse.addWarning("Process FormalParameters not yet supported.");
        }
    }
}

