/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.persistence.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.hibernate.type.Type;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.impl.MetaDataImpl;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.WebTemporaryToken;
import org.ow2.bonita.facade.runtime.impl.CaseImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.LabelImpl;
import org.ow2.bonita.facade.runtime.impl.WebUserImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.persistence.EventDbSession;
import org.ow2.bonita.persistence.IdentityDbSession;
import org.ow2.bonita.persistence.JournalDbSession;
import org.ow2.bonita.persistence.PrivilegeDbSession;
import org.ow2.bonita.persistence.QuerierDbSession;
import org.ow2.bonita.persistence.WebDbSession;
import org.ow2.bonita.persistence.WebTokenManagementDbSession;
import org.ow2.bonita.persistence.db.HibernateDbSession;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessInstanceLastUpdateComparator;
import org.ow2.bonita.util.hibernate.GenericEnumUserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSessionImpl
extends HibernateDbSession
implements QuerierDbSession,
JournalDbSession,
WebDbSession,
IdentityDbSession,
EventDbSession,
PrivilegeDbSession,
WebTokenManagementDbSession {
    private static Type definitionStateUserType = Hibernate.custom(GenericEnumUserType.class, (String[])new String[]{"enumClass"}, (String[])new String[]{ProcessDefinition.ProcessState.class.getName()});
    private static Type activityStateUserType = Hibernate.custom(GenericEnumUserType.class, (String[])new String[]{"enumClass"}, (String[])new String[]{ActivityState.class.getName()});
    private static Type instanceStateUserType = Hibernate.custom(GenericEnumUserType.class, (String[])new String[]{"enumClass"}, (String[])new String[]{InstanceState.class.getName()});

    public DbSessionImpl(Session session) {
        this.setSession(session);
    }

    @Override
    public int getNumberOfParentProcessInstances() {
        Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstances");
        query.setCacheable(true);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfProcessInstances() {
        Query query = this.getSession().getNamedQuery("getNumberOfProcessInstances");
        query.setCacheable(true);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfProcesses() {
        Query query = this.getSession().getNamedQuery("getNumberOfProcesses");
        query.setCacheable(true);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Set<TaskInstance> getUserInstanceTasks(String userId, ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        Query query = this.getSession().getNamedQuery("getUserInstanceTasksWithState");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setString("instanceUUID", instanceUUID.toString());
        query.setParameter("state", (Object)taskState, activityStateUserType);
        result.addAll(query.list());
        return result;
    }

    @Override
    public Set<TaskInstance> getUserTasks(String userId, Collection<ActivityState> taskStates) {
        Query query = this.getSession().getNamedQuery("getUserTasksWithStates");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setParameterList("states", taskStates, activityStateUserType);
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        result.addAll(query.list());
        return result;
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityName) {
        Query query = this.getSession().getNamedQuery("getActivityInstancesWithName");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setString("name", activityName);
        HashSet<InternalActivityInstance> result = new HashSet<InternalActivityInstance>();
        result.addAll(query.list());
        return result;
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, String iterationId) {
        Query query = this.getSession().getNamedQuery("getActivityInstances");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setString("activityName", activityName);
        query.setString("iterationId", iterationId);
        HashSet<InternalActivityInstance> result = new HashSet<InternalActivityInstance>();
        result.addAll(query.list());
        return result;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID) {
        if (rootInstanceUUID == null) {
            return Collections.emptyList();
        }
        Query query = this.getSession().getNamedQuery("getActivityInstancesFromRoot");
        query.setCacheable(true);
        query.setString("rootInstanceUUID", rootInstanceUUID.getValue());
        return query.list();
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs) {
        if (rootInstanceUUIDs == null || rootInstanceUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : rootInstanceUUIDs) {
            uuids.add(processInstanceUUID.getValue());
        }
        Query query = this.getSession().getNamedQuery("getMatchingActivityInstancesFromRoot");
        query.setCacheable(true);
        query.setParameterList("rootInstanceUUIDs", uuids);
        return query.list();
    }

    @Override
    public Map<ProcessInstanceUUID, InternalActivityInstance> getLastUpdatedActivityInstanceFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, boolean considerSystemTaks) {
        if (rootInstanceUUIDs == null || rootInstanceUUIDs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ProcessInstanceUUID, InternalActivityInstance> result = new HashMap<ProcessInstanceUUID, InternalActivityInstance>();
        for (ProcessInstanceUUID processInstanceUUID : rootInstanceUUIDs) {
            Query query = considerSystemTaks ? this.getSession().getNamedQuery("getMatchingActivityInstancesFromRoot") : this.getSession().getNamedQuery("getMatchingHumanTaskInstancesFromRoot");
            query.setCacheable(true);
            query.setParameterList("rootInstanceUUIDs", Arrays.asList(processInstanceUUID.getValue()));
            query.setMaxResults(1);
            List tmp = query.list();
            if (tmp == null || tmp.size() <= 0) continue;
            result.put(processInstanceUUID, (InternalActivityInstance)tmp.get(0));
        }
        return result;
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, ActivityState state) {
        if (rootInstanceUUIDs == null || rootInstanceUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : rootInstanceUUIDs) {
            uuids.add(processInstanceUUID.getValue());
        }
        Query query = this.getSession().getNamedQuery("getMatchingActivityInstancesWithStateFromRoot");
        query.setCacheable(true);
        query.setParameterList("rootInstanceUUIDs", uuids);
        query.setParameter("state", (Object)state, activityStateUserType);
        return query.list();
    }

    @Override
    public TaskInstance getOneTask(String userId, ActivityState taskState) {
        Query query = this.getSession().getNamedQuery("getOneTask");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setParameter("state", (Object)taskState, activityStateUserType);
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public TaskInstance getOneTask(String userId, ProcessDefinitionUUID processUUID, ActivityState taskState) {
        Query query = this.getSession().getNamedQuery("getOneTaskOfProcess");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setString("processUUID", processUUID.getValue());
        query.setParameter("state", (Object)taskState, activityStateUserType);
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public TaskInstance getOneTask(String userId, ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        Query query = this.getSession().getNamedQuery("getOneTaskOfInstance");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setParameter("state", (Object)taskState, activityStateUserType);
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId) {
        Query query = this.getSession().getNamedQuery("getUserInstances");
        query.setCacheable(true);
        query.setString("userId", userId);
        HashSet<InternalProcessInstance> result = new HashSet<InternalProcessInstance>();
        result.addAll(query.list());
        return result;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId, Date minStartDate) {
        Query query = this.getSession().getNamedQuery("getUserInstancesAfterDate");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setLong("minStartDate", minStartDate.getTime());
        HashSet<InternalProcessInstance> result = new HashSet<InternalProcessInstance>();
        result.addAll(query.list());
        return result;
    }

    @Override
    public Set<InternalProcessInstance> getUserParentInstances(String userId, Date minStartDate) {
        Query query = this.getSession().getNamedQuery("getUserParentInstancesAfterDate");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setLong("minStartDate", minStartDate.getTime());
        HashSet<InternalProcessInstance> result = new HashSet<InternalProcessInstance>();
        result.addAll(query.list());
        return result;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstancesExcept(String userId, Set<ProcessInstanceUUID> instances) {
        if (instances == null || instances.isEmpty()) {
            return this.getUserInstances(userId);
        }
        HashSet<String> uuids = new HashSet<String>();
        if (instances != null) {
            for (ProcessInstanceUUID processInstanceUUID : instances) {
                uuids.add(processInstanceUUID.getValue());
            }
        }
        Query query = this.getSession().getNamedQuery("getUserInstancesExcept");
        query.setCacheable(true);
        query.setString("userId", userId);
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "uuids", uuids);
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().getNamedQuery("findActivityInstances");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.toString());
        List results = query.list();
        if (results != null) {
            return new HashSet<InternalActivityInstance>(results);
        }
        return null;
    }

    @Override
    public long getLastProcessInstanceNb(ProcessDefinitionUUID processUUID) {
        Query query = this.getSession().getNamedQuery("getLastProcessInstanceNb");
        query.setCacheable(true);
        query.setString("processUUID", processUUID.getValue());
        query.setMaxResults(1);
        Long result = (Long)query.uniqueResult();
        if (result == null) {
            return -1L;
        }
        return result;
    }

    @Override
    public InternalProcessInstance getProcessInstance(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().getNamedQuery("findProcessInstance");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.toString());
        query.setMaxResults(1);
        return (InternalProcessInstance)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances() {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        Query query = this.getSession().getNamedQuery("findAllProcessInstances");
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("findAllProcessInstances");
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessInstances(int maxResults, long time) {
        Query query = this.getSession().getNamedQuery("getMostRecentProcessInstances");
        query.setCacheable(true);
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentParentProcessInstances(int maxResults, long time) {
        Query query = this.getSession().getNamedQuery("getMostRecentParentProcessInstances");
        query.setCacheable(true);
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentMatchingProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int maxResults, long time) {
        Query query = this.getSession().getNamedQuery("getMostRecentMatchingProcessInstances");
        query.setCacheable(true);
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID uuid : instanceUUIDs) {
            uuids.add(uuid.toString());
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids));
        Collections.sort(allInstances, new ProcessInstanceLastUpdateComparator());
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, 0, maxResults);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessesProcessInstances(Collection<ProcessDefinitionUUID> definitionUUIDs, int maxResults, long time) {
        Query query = this.getSession().getNamedQuery("getMostRecentProcessesProcessInstances");
        query.setCacheable(true);
        query.setFirstResult(0);
        query.setLong("time", time);
        query.setMaxResults(maxResults);
        HashSet<String> uuids = new HashSet<String>();
        if (definitionUUIDs != null) {
            for (ProcessDefinitionUUID uuid : definitionUUIDs) {
                uuids.add(uuid.toString());
            }
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "processUUIDs", uuids));
        Collections.sort(allInstances, new ProcessInstanceLastUpdateComparator());
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, 0, maxResults);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("getParentInstances");
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("getAllProcesses");
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        if (instanceUUIDs != null) {
            for (ProcessInstanceUUID uuid : instanceUUIDs) {
                uuids.add(uuid.toString());
            }
        }
        ArrayList<InternalProcessInstance> allInstances = new ArrayList<InternalProcessInstance>();
        allInstances.addAll(this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids));
        Collections.sort(allInstances, new ProcessInstanceLastUpdateComparator());
        List<InternalProcessInstance> results = Misc.subList(InternalProcessInstance.class, allInstances, fromIndex, pageSize);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public List<ProcessInstanceUUID> getLabelsCaseUUIDs(String ownerName, Set<String> labelNames, int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("getLabelsCaseUUIDs");
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        query.setString("ownerName", ownerName);
        query.setParameterList("labelNames", labelNames);
        return query.list();
    }

    @Override
    public Set<InternalProcessInstance> getParentInstances() {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        Query query = this.getSession().getNamedQuery("getParentInstances");
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public Set<ProcessInstanceUUID> getParentInstancesUUIDs() {
        HashSet<ProcessInstanceUUID> processInsts = new HashSet<ProcessInstanceUUID>();
        Query query = this.getSession().getNamedQuery("getParentInstancesUUIDs");
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) {
        Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        query.setCacheable(true);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID uuid : instanceUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates) {
        Query getActivitiesQuery = this.getSession().getNamedQuery("findActivityInstancesWithTaskState");
        getActivitiesQuery.setCacheable(true);
        getActivitiesQuery.setParameterList("activityStates", activityStates, activityStateUserType);
        List uuids = getActivitiesQuery.list();
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        if (uuids.isEmpty()) {
            return processInsts;
        }
        Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        query.setCacheable(true);
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates) {
        Query getProcessInstancesQuery = this.getSession().getNamedQuery("findProcessInstancesWithInstanceStates");
        getProcessInstancesQuery.setCacheable(true);
        getProcessInstancesQuery.setParameterList("instanceStates", instanceStates, definitionStateUserType);
        List uuids = getProcessInstancesQuery.list();
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        if (uuids.isEmpty()) {
            return processInsts;
        }
        Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        query.setCacheable(true);
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        Query query = this.getSession().getNamedQuery("findProcessInstances");
        query.setCacheable(true);
        query.setString("processUUID", processUUID.toString());
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID, InstanceState instanceState) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        Query query = this.getSession().getNamedQuery("findProcessInstancesWithState");
        query.setCacheable(true);
        query.setString("processUUID", processUUID.toString());
        query.setParameter("state", (Object)instanceState, instanceStateUserType);
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public TaskInstance getTaskInstance(ActivityInstanceUUID taskUUID) {
        Query query = this.getSession().getNamedQuery("findTaskInstance");
        query.setCacheable(true);
        query.setString("taskUUID", taskUUID.toString());
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public Set<TaskInstance> getTaskInstances(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().getNamedQuery("findTaskInstances");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.toString());
        HashSet<TaskInstance> taskInstances = new HashSet<TaskInstance>();
        List results = query.list();
        if (results != null) {
            taskInstances.addAll(results);
        }
        return taskInstances;
    }

    private Set<InternalProcessDefinition> getProcessSet(Query query) {
        List results = query.list();
        if (results != null) {
            return new HashSet<InternalProcessDefinition>(results);
        }
        return null;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses() {
        Query query = this.getSession().getNamedQuery("getAllProcesses");
        query.setCacheable(true);
        return this.getProcessSet(query);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(String processId) {
        Query query = this.getSession().getNamedQuery("getProcesses2");
        query.setCacheable(true);
        query.setString("processId", processId);
        return this.getProcessSet(query);
    }

    @Override
    public InternalProcessDefinition getProcess(ProcessDefinitionUUID processUUID) {
        Query query = this.getSession().getNamedQuery("getProcess");
        query.setCacheable(true);
        query.setString("processUUID", processUUID.toString());
        query.setMaxResults(1);
        return (InternalProcessDefinition)query.uniqueResult();
    }

    @Override
    public InternalProcessDefinition getProcess(String processId, String version) {
        Query query = this.getSession().getNamedQuery("getProcessFromIdAndVersion");
        query.setCacheable(true);
        query.setString("processId", processId);
        query.setString("version", version);
        return (InternalProcessDefinition)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(ProcessDefinition.ProcessState processState) {
        Query query = this.getSession().getNamedQuery("getProcessesFromState");
        query.setParameter("state", (Object)processState, definitionStateUserType);
        query.setCacheable(true);
        return this.getProcessSet(query);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(String processId, ProcessDefinition.ProcessState processState) {
        Query query = this.getSession().getNamedQuery("getProcessesFromProcessIdAndState");
        query.setParameter("state", (Object)processState, definitionStateUserType);
        query.setCacheable(true);
        query.setString("processId", processId);
        return this.getProcessSet(query);
    }

    @Override
    public String getLastProcessVersion(String processName) {
        Query query = this.getSession().getNamedQuery("getLastProcessVersion");
        query.setCacheable(true);
        query.setString("name", processName);
        query.setMaxResults(1);
        return (String)query.uniqueResult();
    }

    @Override
    public InternalProcessDefinition getLastProcess(String processId, ProcessDefinition.ProcessState processState) {
        Query query = this.getSession().getNamedQuery("getLastProcessFromProcessIdAndState");
        query.setParameter("state", (Object)processState, definitionStateUserType);
        query.setCacheable(true);
        query.setString("processId", processId);
        query.setMaxResults(1);
        return (InternalProcessDefinition)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessDefinition> getDependentProcesses(ProcessDefinitionUUID processUUID) {
        Query query = this.getSession().getNamedQuery("getDependentProcesses");
        query.setCacheable(true);
        query.setString("processName", processUUID.getProcessName());
        query.setString("processUUID", processUUID.getValue());
        return this.getProcessSet(query);
    }

    @Override
    public InternalActivityInstance getActivityInstance(ProcessInstanceUUID instanceUUID, String activityId, String iterationId, String activityInstanceId) {
        Query query = this.getSession().getNamedQuery("getActivityInstance");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.toString());
        query.setString("activityId", activityId);
        query.setString("iterationId", iterationId);
        query.setString("activityInstanceId", activityInstanceId);
        return (InternalActivityInstance)query.uniqueResult();
    }

    @Override
    public InternalActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) {
        Query query = this.getSession().getNamedQuery("getActivityInstanceFromUUID");
        query.setCacheable(true);
        query.setString("activityUUID", activityInstanceUUID.toString());
        return (InternalActivityInstance)query.uniqueResult();
    }

    @Override
    public ActivityState getActivityInstanceState(ActivityInstanceUUID activityInstanceUUID) {
        Query query = this.getSession().getNamedQuery("getActivityInstanceStateFromUUID");
        query.setCacheable(true);
        query.setString("activityUUID", activityInstanceUUID.toString());
        return (ActivityState)((Object)query.uniqueResult());
    }

    @Override
    public InternalActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefinitionUUID) {
        Query query = this.getSession().getNamedQuery("getActivityDefinition");
        query.setCacheable(true);
        query.setString("activityUUID", activityDefinitionUUID.toString());
        query.setMaxResults(1);
        return (InternalActivityDefinition)query.uniqueResult();
    }

    @Override
    public Set<InternalProcessInstance> getUpdatedWebProcessInstances(String user, int fromIndex, int pageSize) {
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        Query query = this.getSession().getNamedQuery("getUpdatedWebProcessInstances");
        query.setString("user", user);
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        List results = query.list();
        if (results != null) {
            processInsts.addAll(results);
        }
        return processInsts;
    }

    @Override
    public Execution getExecutionWithEventUUID(String eventUUID) {
        Query query = this.getSession().getNamedQuery("getExecutionWithEventUUID");
        query.setCacheable(true);
        query.setString("eventUUID", eventUUID);
        return (Execution)query.uniqueResult();
    }

    @Override
    public Set<Execution> getExecutions(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().getNamedQuery("getInstanceExecutions");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        HashSet<Execution> executions = new HashSet<Execution>();
        executions.addAll(query.list());
        return executions;
    }

    @Override
    public Execution getExecutionPointingOnNode(ActivityInstanceUUID activityUUID) {
        Query query = this.getSession().getNamedQuery("findInstanceExecutionPointingOnNode");
        query.setCacheable(true);
        query.setString("activityUUID", activityUUID.toString());
        return (Execution)query.uniqueResult();
    }

    @Override
    public MetaDataImpl getMetaData(String key) {
        Query query = this.getSession().getNamedQuery("getMetaData");
        query.setCacheable(true);
        query.setString("key", key);
        return (MetaDataImpl)query.uniqueResult();
    }

    @Override
    public Set<ProcessInstanceUUID> getAllCases() {
        HashSet<ProcessInstanceUUID> result = new HashSet<ProcessInstanceUUID>();
        Query query = this.getSession().getNamedQuery("getAllCases");
        query.setCacheable(true);
        result.addAll(query.list());
        return result;
    }

    @Override
    public Set<CaseImpl> getCases(Set<ProcessInstanceUUID> caseUUIDs) {
        HashSet<String> uuids = new HashSet<String>();
        if (caseUUIDs != null) {
            for (ProcessInstanceUUID processInstanceUUID : caseUUIDs) {
                uuids.add(processInstanceUUID.getValue());
            }
        }
        Query query = this.getSession().getNamedQuery("getMatchingCases");
        query.setCacheable(true);
        return this.executeSplittedQuery(CaseImpl.class, query, "uuids", uuids);
    }

    @Override
    public List<LabelImpl> getUserCustomLabels(String ownerName) {
        ArrayList<LabelImpl> result = new ArrayList<LabelImpl>();
        Query query = this.getSession().getNamedQuery("getUserCustomLabels");
        query.setCacheable(true);
        query.setString("ownerName", ownerName);
        result.addAll(query.list());
        return result;
    }

    @Override
    public List<LabelImpl> getSystemLabels(String ownerName) {
        ArrayList<LabelImpl> result = new ArrayList<LabelImpl>();
        Query query = this.getSession().getNamedQuery("getSystemLabels");
        query.setString("ownerName", ownerName);
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public LabelImpl getLabel(String ownerName, String labelName) {
        Query query = this.getSession().getNamedQuery("getLabelByID");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        query.setCacheable(true);
        query.setMaxResults(1);
        LabelImpl theResult = (LabelImpl)query.uniqueResult();
        return theResult;
    }

    @Override
    public WebUserImpl getUser(String userName) {
        Query query = this.getSession().getNamedQuery("getUser");
        query.setString("name", userName);
        query.setCacheable(true);
        query.setMaxResults(1);
        WebUserImpl theResult = (WebUserImpl)query.uniqueResult();
        return theResult;
    }

    @Override
    public Set<LabelImpl> getLabels(String ownerName) {
        HashSet<LabelImpl> result = new HashSet<LabelImpl>();
        Query query = this.getSession().getNamedQuery("getAllLabels");
        query.setString("ownerName", ownerName);
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<LabelImpl> getCaseLabels(String ownerName, ProcessInstanceUUID case_) {
        Query getUserCases = this.getSession().getNamedQuery("getUserCases");
        getUserCases.setString("ownerName", ownerName);
        getUserCases.setString("caseId", case_.getValue());
        getUserCases.setCacheable(true);
        List caseLabelsNames = getUserCases.list();
        Set<LabelImpl> result = new HashSet<LabelImpl>();
        if (!caseLabelsNames.isEmpty()) {
            Query query = this.getSession().getNamedQuery("getLabels");
            query.setString("ownerName", ownerName);
            query.setCacheable(true);
            result = this.executeSplittedQuery(LabelImpl.class, query, "labelNames", caseLabelsNames);
        }
        return result;
    }

    private <T> Set<T> executeSplittedQuery(Class<T> clazz, Query query, String parameterName, Collection<? extends Object> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        if (values.size() <= 500) {
            query.setParameterList(parameterName, values);
            List l = query.list();
            result.addAll(l);
            return result;
        }
        List<Collection<Object>> newValues = Misc.splitCollection(values, 500);
        for (Collection<Object> set : newValues) {
            query.setParameterList(parameterName, set);
            List l = query.list();
            result.addAll(l);
        }
        return result;
    }

    private <T> List<T> executeSplittedQueryList(Class<T> clazz, Query query, String parameterName, Collection<? extends Object> values) {
        return this.executeSplittedQueryList(clazz, query, parameterName, values, 500);
    }

    private <T> List<T> executeSplittedQueryList(Class<T> clazz, Query query, String parameterName, Collection<? extends Object> values, int size) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        if (values.size() <= size) {
            query.setParameterList(parameterName, values);
            return query.list();
        }
        List<Collection<Object>> newValues = Misc.splitCollection(values, size);
        for (Collection<Object> set : newValues) {
            query.setParameterList(parameterName, set);
            List l = query.list();
            result.addAll(l);
        }
        return result;
    }

    @Override
    public Set<CaseImpl> getCases(String ownerName, String labelName) {
        HashSet<CaseImpl> result = new HashSet<CaseImpl>();
        Query query = this.getSession().getNamedQuery("getLabelCases");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<CaseImpl> getCases(ProcessInstanceUUID case_) {
        HashSet<CaseImpl> result = new HashSet<CaseImpl>();
        Query query = this.getSession().getNamedQuery("getCases");
        query.setString("caseId", case_.getValue());
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public CaseImpl getCase(ProcessInstanceUUID caseUUID, String ownerName, String labelName) {
        Query query = this.getSession().getNamedQuery("getCase");
        query.setString("caseUUID", caseUUID.getValue());
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        query.setCacheable(true);
        return (CaseImpl)query.uniqueResult();
    }

    @Override
    public Set<LabelImpl> getLabels(String ownerName, Set<String> labelsName) {
        Query query = this.getSession().getNamedQuery("getLabels");
        query.setString("ownerName", ownerName);
        query.setCacheable(true);
        Set<LabelImpl> result = this.executeSplittedQuery(LabelImpl.class, query, "labelNames", labelsName);
        return result;
    }

    @Override
    public Set<LabelImpl> getLabels(Set<String> labelsName) {
        Query query = this.getSession().getNamedQuery("getLabelsWithName");
        query.setCacheable(true);
        Set<LabelImpl> result = this.executeSplittedQuery(LabelImpl.class, query, "labelNames", labelsName);
        return result;
    }

    @Override
    public int getCasesNumberWithTwoLabels(String ownerName, String label1Name, String label2Name) {
        Query query = this.getSession().getNamedQuery("getCasesNumberWithTwoLabels");
        query.setString("label1", CaseImpl.buildLabel(ownerName, label1Name));
        query.setString("label2", CaseImpl.buildLabel(ownerName, label2Name));
        query.setReadOnly(true);
        int result = ((Long)query.uniqueResult()).intValue();
        return result;
    }

    @Override
    public int getCasesNumber(String ownerName, String labelName) {
        Query query = this.getSession().getNamedQuery("getCasesNumber");
        query.setString("ownerName", ownerName);
        query.setString("label", labelName);
        query.setReadOnly(true);
        int result = ((Long)query.uniqueResult()).intValue();
        return result;
    }

    @Override
    public Set<CaseImpl> getCasesWithTwoLabels(String ownerName, String label1Name, String label2Name, int limit) {
        Query query = this.getSession().getNamedQuery("getCasesWithTwoLabelsWithLimit");
        query.setString("label1", CaseImpl.buildLabel(ownerName, label1Name));
        query.setString("label2", CaseImpl.buildLabel(ownerName, label2Name));
        query.setReadOnly(true);
        query.setMaxResults(limit);
        List results = query.list();
        if (results != null) {
            return new HashSet<CaseImpl>(results);
        }
        return new HashSet<CaseImpl>();
    }

    @Override
    public Set<CaseImpl> getCases(String ownerName, String labelName, int limit) {
        Query query = this.getSession().getNamedQuery("getLabelCases");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        query.setMaxResults(limit);
        List results = query.list();
        if (results != null) {
            return new HashSet<CaseImpl>(results);
        }
        return new HashSet<CaseImpl>();
    }

    @Override
    public Set<ProcessInstanceUUID> getCases(String ownerName, Set<String> theLabelsName) {
        Query query = this.getSession().getNamedQuery("getLabelsCases");
        query.setString("ownerName", ownerName);
        query.setCacheable(true);
        return this.executeSplittedQuery(ProcessInstanceUUID.class, query, "labelNames", theLabelsName);
    }

    @Override
    public void deleteAllCases() {
        Session session = this.getSession();
        Query query = session.getNamedQuery("getAllWebCases");
        query.setCacheable(true);
        for (Object webCase : query.list()) {
            session.delete(webCase);
        }
    }

    @Override
    public void deleteCases(Set<ProcessInstanceUUID> webCases) {
        Session session = this.getSession();
        Query query = session.getNamedQuery("getMatchingCases");
        query.setCacheable(true);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : webCases) {
            uuids.add(processInstanceUUID.getValue());
        }
        for (CaseImpl caseImpl : this.executeSplittedQuery(CaseImpl.class, query, "uuids", uuids)) {
            session.delete((Object)caseImpl);
        }
    }

    @Override
    public Set<ProcessInstanceUUID> getCasesUUIDs(String ownerName, String labelName, Set<ProcessInstanceUUID> cases) {
        HashSet<String> uuids = new HashSet<String>();
        if (cases != null) {
            for (ProcessInstanceUUID processInstanceUUID : cases) {
                uuids.add(processInstanceUUID.getValue());
            }
        }
        Query query = this.getSession().getNamedQuery("getLabelCasesUUIDsSublist");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        query.setCacheable(true);
        return this.executeSplittedQuery(ProcessInstanceUUID.class, query, "caseUUIDs", uuids);
    }

    @Override
    public Set<ProcessInstanceUUID> getLabelCases(String labelName, Set<ProcessInstanceUUID> caseUUIDs) {
        if (caseUUIDs == null || caseUUIDs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : caseUUIDs) {
            uuids.add(processInstanceUUID.getValue());
        }
        Query query = this.getSession().getNamedQuery("getLabelNameCases");
        query.setString("labelName", labelName);
        query.setCacheable(true);
        return this.executeSplittedQuery(ProcessInstanceUUID.class, query, "uuids", uuids);
    }

    @Override
    public Set<CaseImpl> getLabelCases(String ownerName, Set<String> labelsNames, Set<ProcessInstanceUUID> caseUUIDs) {
        if (caseUUIDs == null || caseUUIDs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessInstanceUUID processInstanceUUID : caseUUIDs) {
            uuids.add(processInstanceUUID.getValue());
        }
        Query query = this.getSession().getNamedQuery("getLabelsNameCases");
        query.setParameterList("labelsNames", labelsNames);
        query.setString("ownerName", ownerName);
        query.setCacheable(true);
        return this.executeSplittedQuery(CaseImpl.class, query, "uuids", uuids);
    }

    @Override
    public Set<CaseImpl> getCases(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList) {
        HashSet<String> uuids = new HashSet<String>();
        if (caseList != null) {
            for (ProcessInstanceUUID processInstanceUUID : caseList) {
                uuids.add(processInstanceUUID.getValue());
            }
        }
        Query query = this.getSession().getNamedQuery("getLabelCasesSublist");
        query.setString("ownerName", ownerName);
        query.setString("labelName", labelName);
        query.setCacheable(true);
        return this.executeSplittedQuery(CaseImpl.class, query, "caseUUIDs", uuids);
    }

    @Override
    public RoleImpl getRole(String name) {
        Query query = this.getSession().getNamedQuery("findRole");
        query.setCacheable(true);
        query.setString("name", name);
        return (RoleImpl)query.uniqueResult();
    }

    @Override
    public Set<RoleImpl> getRoles() {
        Query query = this.getSession().getNamedQuery("getRoles");
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            return new HashSet<RoleImpl>(results);
        }
        return new HashSet<RoleImpl>();
    }

    @Override
    public UserImpl getIdentityUser(String username) {
        Query query = this.getSession().getNamedQuery("findIdentityUser");
        query.setCacheable(true);
        query.setString("username", username);
        return (UserImpl)query.uniqueResult();
    }

    @Override
    public Set<UserImpl> getIdentityUsers() {
        Query query = this.getSession().getNamedQuery("getIdentityUsers");
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            return new HashSet<UserImpl>(results);
        }
        return new HashSet<UserImpl>();
    }

    @Override
    public List<Integer> getNumberOfExecutingCasesPerDay(Date since, Date to) {
        ArrayList<Integer> executingCases = new ArrayList<Integer>();
        while (since.before(to) || since.equals(to)) {
            Date nextDayBegining = DateUtil.getBeginningOfTheDay(DateUtil.getNextDay(since));
            Query query = this.getSession().getNamedQuery("getNumberOfExecutingCases");
            query.setCacheable(true);
            query.setLong("date", nextDayBegining.getTime());
            executingCases.add(((Long)query.uniqueResult()).intValue());
            since = DateUtil.getNextDay(since);
        }
        return executingCases;
    }

    @Override
    public List<Integer> getNumberOfFinishedCasesPerDay(Date since, Date to) {
        ArrayList<Integer> finishedCases = new ArrayList<Integer>();
        while (since.before(to) || since.equals(to)) {
            Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(since);
            Date nextBeginningOfTheDay = DateUtil.getBeginningOfTheDay(DateUtil.getNextDay(since));
            Query query = this.getSession().getNamedQuery("getNumberOfFinishedCases");
            query.setCacheable(true);
            query.setLong("beginningOfTheDay", beginningOfTheDay.getTime());
            query.setLong("nextBeginningOfTheDay", nextBeginningOfTheDay.getTime());
            finishedCases.add(((Long)query.uniqueResult()).intValue());
            since = DateUtil.getNextDay(since);
        }
        return finishedCases;
    }

    @Override
    public List<Integer> getNumberOfOpenStepsPerDay(Date since, Date to) {
        ArrayList<Integer> finishedCases = new ArrayList<Integer>();
        while (since.before(to) || since.equals(to)) {
            Date nextDayBegining = DateUtil.getBeginningOfTheDay(DateUtil.getNextDay(since));
            Query query = this.getSession().getNamedQuery("getNumberOfOpenSteps2");
            query.setCacheable(true);
            query.setLong("date", nextDayBegining.getTime());
            finishedCases.add(((Long)query.uniqueResult()).intValue());
            since = DateUtil.getNextDay(since);
        }
        return finishedCases;
    }

    @Override
    public int getNumberOfOpenSteps() {
        Query query = this.getSession().getNamedQuery("getNumberOfOpenSteps");
        query.setCacheable(true);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfOverdueSteps(Date currentDate) {
        Query query = this.getSession().getNamedQuery("getNumberOfOverdueSteps");
        query.setCacheable(true);
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfStepsAtRisk(Date currentDate, Date atRisk) {
        Query query = this.getSession().getNamedQuery("getNumberOfStepsAtRisk");
        query.setCacheable(true);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserOpenSteps(String userId) {
        Query query = this.getSession().getNamedQuery("getNumberOfUserOpenSteps");
        query.setCacheable(true);
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserOverdueSteps(String userId, Date currentDate) {
        Query query = this.getSession().getNamedQuery("getNumberOfUserOverdueSteps");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserStepsAtRisk(String userId, Date currentDate, Date atRisk) {
        Query query = this.getSession().getNamedQuery("getNumberOfUserStepsAtRisk");
        query.setCacheable(true);
        query.setString("userId", userId);
        query.setLong("atRisk", atRisk.getTime());
        query.setLong("currentDate", currentDate.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfFinishedSteps(int priority, Date since) {
        Query query = this.getSession().getNamedQuery("getNumberOfFinishedSteps");
        query.setCacheable(true);
        query.setInteger("priority", priority);
        query.setLong("since", since.getTime());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfOpenSteps(int priority) {
        Query query = this.getSession().getNamedQuery("getNumberOfPriorityOpenSteps");
        query.setCacheable(true);
        query.setInteger("priority", priority);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserFinishedSteps(String userId, int priority, Date since) {
        Query query = this.getSession().getNamedQuery("getNumberOfUserFinishedSteps");
        query.setCacheable(true);
        query.setInteger("priority", priority);
        query.setLong("since", since.getTime());
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfUserOpenSteps(String userId, int priority) {
        Query query = this.getSession().getNamedQuery("getNumberOfPriorityUserOpenSteps");
        query.setCacheable(true);
        query.setInteger("priority", priority);
        query.setString("userId", userId);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(ProcessInstanceUUID instanceUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        Query query = this.getSession().getNamedQuery("getInstanceIncomingEvents");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getPermanentIncomingEvents(ActivityDefinitionUUID activityUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        Query query = this.getSession().getNamedQuery("getPermanentIncomingEvents");
        query.setCacheable(true);
        query.setString("activityUUID", activityUUID.getValue());
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public IncomingEventInstance getIncomingEvent(ProcessInstanceUUID instanceUUID, String name) {
        Query query = this.getSession().getNamedQuery("getUniqueInstanceIncomingEvent");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        query.setString("eventName", name);
        return (IncomingEventInstance)query.uniqueResult();
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(ActivityDefinitionUUID activityUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        Query query = this.getSession().getNamedQuery("getActivityDefinitionIncomingEvents");
        query.setCacheable(true);
        query.setString("activityUUID", activityUUID.getValue());
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents(ProcessInstanceUUID instanceUUID) {
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        Query query = this.getSession().getNamedQuery("getInstanceOutgoingEvents");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents() {
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        Query query = this.getSession().getNamedQuery("getOutgoingEvents");
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID actiivtyUUID) {
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        Query query = this.getSession().getNamedQuery("getOutgoingEventsWithUUID");
        query.setString("name", eventName);
        query.setString("processName", toProcessName);
        query.setString("activityName", toActivityName);
        query.setString("activityUUID", actiivtyUUID.getValue());
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID actiivtyUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        Query query = this.getSession().getNamedQuery("getIncomingEventsWithUUID");
        query.setString("name", eventName);
        query.setString("processName", toProcessName);
        query.setString("activityName", toActivityName);
        query.setString("activityUUID", actiivtyUUID.getValue());
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<EventInstance> getConsumedEvents() {
        HashSet<EventInstance> result = new HashSet<EventInstance>();
        Query oeiQuery = this.getSession().getNamedQuery("getOutgoingConsumedEvents");
        oeiQuery.setCacheable(true);
        result.addAll(oeiQuery.list());
        Query ieiQuery = this.getSession().getNamedQuery("getIncomingConsumedEvents");
        ieiQuery.setCacheable(true);
        result.addAll(ieiQuery.list());
        return result;
    }

    @Override
    public Set<OutgoingEventInstance> getOverdueEvents() {
        long currentTime = System.currentTimeMillis();
        HashSet<OutgoingEventInstance> result = new HashSet<OutgoingEventInstance>();
        Query oeiQuery = this.getSession().getNamedQuery("getOverdueEvents");
        oeiQuery.setLong("current", currentTime);
        oeiQuery.setCacheable(true);
        result.addAll(oeiQuery.list());
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents() {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        Query query = this.getSession().getNamedQuery("getIncomingEvents");
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<IncomingEventInstance> getActivityIncomingEvents(ActivityInstanceUUID activityUUID) {
        HashSet<IncomingEventInstance> result = new HashSet<IncomingEventInstance>();
        Query query = this.getSession().getNamedQuery("getActivityIncomingEvents");
        query.setString("activityUUID", activityUUID.getValue());
        query.setCacheable(true);
        List theTempResult = query.list();
        result.addAll(theTempResult);
        return result;
    }

    @Override
    public Set<EventCouple> getEventsCouples() {
        Query query = this.getSession().getNamedQuery("getEventsCouples");
        query.setCacheable(true);
        query.setLong("current", System.currentTimeMillis());
        query.setResultTransformer(Transformers.aliasToBean(EventCouple.class));
        List couples = query.list();
        HashSet<EventCouple> result = new HashSet<EventCouple>();
        result.addAll(couples);
        return result;
    }

    @Override
    public IncomingEventInstance getIncomingEvent(long incomingId) {
        Query query = this.getSession().getNamedQuery("getIncomingEvent");
        query.setCacheable(true);
        query.setLong("id", incomingId);
        return (IncomingEventInstance)query.uniqueResult();
    }

    @Override
    public OutgoingEventInstance getOutgoingEvent(long outgoingId) {
        Query query = this.getSession().getNamedQuery("getOutgoingEvent");
        query.setCacheable(true);
        query.setLong("id", outgoingId);
        return (OutgoingEventInstance)query.uniqueResult();
    }

    @Override
    public Long getNextDueDate() {
        Query query = this.getSession().getNamedQuery("getNextDueDate");
        query.setCacheable(true);
        query.setMaxResults(1);
        Object result = query.uniqueResult();
        if (result != null) {
            return (Long)result;
        }
        return null;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs) {
        Query query = this.getSession().getNamedQuery("getProcessesList");
        query.setCacheable(true);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, ProcessDefinition.ProcessState processState) {
        Query query = this.getSession().getNamedQuery("getProcessesListByState");
        query.setParameter("state", (Object)processState);
        query.setCacheable(true);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("getAllProcessesList");
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public InternalProcessDefinition getLastProcess(Set<ProcessDefinitionUUID> definitionUUIDs, ProcessDefinition.ProcessState processState) {
        Query query = this.getSession().getNamedQuery("getLastProcessFromProcessSetAndState");
        query.setParameter("state", (Object)processState, definitionStateUserType);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setCacheable(true);
        query.setMaxResults(1);
        Set<InternalProcessDefinition> result = this.executeSplittedQuery(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
        return result.iterator().next();
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        Query query = this.getSession().getNamedQuery("getProcessInstancesFromDefinitionUUIDs");
        query.setCacheable(true);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId, Set<ProcessDefinitionUUID> definitionUUIDs) {
        Query query = this.getSession().getNamedQuery("getUserInstancesFromDefinitionUUIDs");
        query.setCacheable(true);
        query.setString("userId", userId);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public int getNumberOfProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        Query query = this.getSession().getNamedQuery("getNumberOfProcessInstancesFromDefinitionUUIDs");
        query.setCacheable(true);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfParentProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        Query query = this.getSession().getNamedQuery("getNumberOfParentProcessInstancesFromDefinitionUUIDs");
        query.setCacheable(true);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates, Set<ProcessDefinitionUUID> definitionUUIDs) {
        Query getActivitiesQuery = this.getSession().getNamedQuery("findActivityInstancesWithTaskStateAndDefinitionsUUIDs");
        getActivitiesQuery.setCacheable(true);
        getActivitiesQuery.setParameterList("activityStates", activityStates, activityStateUserType);
        List uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        getActivitiesQuery.setParameterList("definitionsUUIDs", uuids);
        uuids = getActivitiesQuery.list();
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        if (uuids.isEmpty()) {
            return processInsts;
        }
        Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        query.setCacheable(true);
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        Query getProcessInstancesQuery = this.getSession().getNamedQuery("ProcessInstancesWithInstanceStatesAndDefinitionsUUIDs");
        getProcessInstancesQuery.setCacheable(true);
        getProcessInstancesQuery.setParameterList("instanceStates", instanceStates, instanceStateUserType);
        List uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : visibleProcessUUIDs) {
            uuids.add(uuid.toString());
        }
        getProcessInstancesQuery.setParameterList("definitionsUUIDs", uuids);
        uuids = getProcessInstancesQuery.list();
        HashSet<InternalProcessInstance> processInsts = new HashSet<InternalProcessInstance>();
        if (uuids.isEmpty()) {
            return processInsts;
        }
        Query query = this.getSession().getNamedQuery("findMatchingProcessInstances");
        query.setCacheable(true);
        return this.executeSplittedQuery(InternalProcessInstance.class, query, "instanceUUIDs", uuids);
    }

    @Override
    public TaskInstance getOneTask(String userId, ActivityState taskState, Set<ProcessDefinitionUUID> definitionUUIDs) {
        Query query = this.getSession().getNamedQuery("getOneTaskOfProcessFromDefinitionUUIDs");
        query.setCacheable(true);
        query.setString("userId", userId);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("definitionsUUIDs", uuids);
        query.setParameter("state", (Object)taskState, activityStateUserType);
        query.setMaxResults(1);
        return (TaskInstance)query.uniqueResult();
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("getProcessInstancesWithDefinitionUUIDs");
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : definitionUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessInstance.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public Rule getRule(String name) {
        Query query = this.getSession().getNamedQuery("getRuleByName");
        query.setCacheable(true);
        query.setString("name", name);
        query.setMaxResults(1);
        return (Rule)query.uniqueResult();
    }

    @Override
    public Set<Rule> getRules() {
        Query query = this.getSession().getNamedQuery("getRules");
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Rule> getRules(Set<String> rulesName) {
        Query query = this.getSession().getNamedQuery("getRuleListByName");
        query.setCacheable(true);
        query.setParameterList("names", rulesName);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Rule> getRulesByType(Set<String> ruleTypes) {
        Query query = this.getSession().getNamedQuery("getRuleListByType");
        query.setCacheable(true);
        query.setParameterList("types", ruleTypes);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Rule> getAllApplicableRules(String entityID) {
        Query query = this.getSession().getNamedQuery("getRuleListByEntity");
        query.setCacheable(true);
        query.setString("entity", entityID);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Rule> getAllApplicableRules(String entityID, Rule.RuleType ruleType) {
        Query query = this.getSession().getNamedQuery("getRuleListByEntityAndType");
        query.setCacheable(true);
        query.setString("entity", entityID);
        String name = ruleType.name();
        query.setString("ruletype", name);
        List results = query.list();
        if (results != null) {
            return new HashSet<Rule>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public List<InternalProcessDefinition> getProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("getAllProcessesListExcept");
        query.setCacheable(true);
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQueryList(InternalProcessDefinition.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public int getNumberOfActivityInstanceComments(ActivityInstanceUUID activityUUID) {
        Query query = this.getSession().getNamedQuery("getNumberOfActivityComments");
        query.setCacheable(true);
        query.setString("activityUUID", activityUUID.getValue());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfComments(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().getNamedQuery("getNumberOfAllComments");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public int getNumberOfProcessInstanceComments(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().getNamedQuery("getNumberOfInstanceComments");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public Map<ActivityInstanceUUID, Integer> getNumberOfActivityInstanceComments(Set<ActivityInstanceUUID> activityUUIDs) {
        Query query = this.getSession().getNamedQuery("getActivitiesComments");
        query.setCacheable(true);
        ArrayList<String> uuids = new ArrayList<String>();
        for (ActivityInstanceUUID uuid : activityUUIDs) {
            uuids.add(uuid.toString());
        }
        query.setParameterList("uuids", uuids);
        List comments = query.list();
        HashMap<ActivityInstanceUUID, Integer> result = new HashMap<ActivityInstanceUUID, Integer>();
        for (Comment comment : comments) {
            ActivityInstanceUUID activityUUID = comment.getActivityUUID();
            if (result.containsKey(activityUUID)) {
                result.put(activityUUID, (Integer)result.get(activityUUID) + 1);
                continue;
            }
            result.put(activityUUID, 1);
        }
        return result;
    }

    @Override
    public List<Comment> getActivityInstanceCommentFeed(ActivityInstanceUUID activityUUID) {
        Query query = this.getSession().getNamedQuery("getActivityComments");
        query.setCacheable(true);
        query.setString("activityUUID", activityUUID.getValue());
        return query.list();
    }

    @Override
    public List<Comment> getProcessInstanceCommentFeed(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().getNamedQuery("getInstanceComments");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        return query.list();
    }

    @Override
    public List<Comment> getCommentFeed(ProcessInstanceUUID instanceUUID) {
        Query query = this.getSession().getNamedQuery("getAllComments");
        query.setCacheable(true);
        query.setString("instanceUUID", instanceUUID.getValue());
        return query.list();
    }

    @Override
    public List<Rule> getRules(Rule.RuleType ruleType, int fromIndex, int pageSize) {
        Query query = this.getSession().getNamedQuery("getRuleListByExactType");
        query.setCacheable(true);
        query.setString("ruletype", ruleType.name());
        query.setFirstResult(fromIndex);
        query.setMaxResults(pageSize);
        List results = query.list();
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    @Override
    public Set<String> getAllExceptions(String entityID, Rule.RuleType ruleType) {
        Query query = this.getSession().getNamedQuery("getExceptionListByEntityAndRuleType");
        query.setString("entity", entityID);
        query.setString("ruletype", ruleType.name());
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            return new HashSet<String>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<ProcessDefinitionUUID> getAllProcessDefinitionUUIDs() {
        Query query = this.getSession().getNamedQuery("getAllProcessDefinitionUUIDs");
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            return new HashSet<ProcessDefinitionUUID>(results);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<ProcessDefinitionUUID> getAllProcessDefinitionUUIDsExcept(Set<ProcessDefinitionUUID> processUUIDs) {
        Query query = this.getSession().getNamedQuery("getAllProcessDefinitionUUIDsExcept");
        query.setCacheable(true);
        HashSet<String> uuids = new HashSet<String>();
        for (ProcessDefinitionUUID uuid : processUUIDs) {
            uuids.add(uuid.toString());
        }
        return this.executeSplittedQuery(ProcessDefinitionUUID.class, query, "definitionsUUIDs", uuids);
    }

    @Override
    public long getNumberOfRules(Rule.RuleType ruleType) {
        Query query = this.getSession().getNamedQuery("getNumberOfRulesForType");
        query.setString("ruletype", ruleType.name());
        query.setCacheable(true);
        return ((Long)query.uniqueResult()).intValue();
    }

    @Override
    public WebTemporaryToken getToken(String token) {
        Query query = this.getSession().getNamedQuery("getTemporaryTokenFromKey");
        query.setString("tokenKey", token);
        query.setCacheable(true);
        query.setMaxResults(1);
        return (WebTemporaryToken)query.uniqueResult();
    }

    @Override
    public Set<WebTemporaryToken> getExpiredTokens() {
        Query query = this.getSession().getNamedQuery("getExpiredTemporaryTokens");
        query.setLong("currentDate", new Date().getTime());
        query.setCacheable(true);
        List results = query.list();
        if (results != null) {
            return new HashSet<WebTemporaryToken>(results);
        }
        return Collections.emptySet();
    }
}

