/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.LogFactory;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractClassLoader
extends URLClassLoader {
    private static final Logger LOG = Logger.getLogger(AbstractClassLoader.class.getName());
    private static final LargeDataRepository ldr = EnvTool.getLargeDataRepository();
    protected Map<String, byte[]> otherResources;
    protected Set<URL> urls;

    AbstractClassLoader(List<String> categories, ClassLoader parent) {
        super(new URL[0], parent);
        Map<String, byte[]> resources = ldr.getData(byte[].class, categories);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating a new AbstratctClassLoader...");
        }
        if (resources != null) {
            this.otherResources = new HashMap<String, byte[]>();
            if (Misc.isOnWindows()) {
                this.urls = new HashSet<URL>();
            }
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                if (resource.getKey().matches(".*\\.jar")) {
                    String path = ldr.getDataPath(categories, resource.getKey());
                    try {
                        URL url = new File(path).toURL();
                        if (Misc.isOnWindows()) {
                            this.urls.add(url);
                        }
                        this.addURL(url);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.otherResources.put(resource.getKey(), resource.getValue());
            }
            if (this.otherResources.isEmpty()) {
                this.otherResources = null;
            }
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = this.getInternalInputstream(name);
        if (is == null && name.startsWith("/")) {
            is = this.getInternalInputstream(name.substring(1));
        }
        return is;
    }

    private InputStream getInternalInputstream(String name) {
        byte[] classData = this.loadProcessResource(name);
        if (classData != null) {
            return new ByteArrayInputStream(classData);
        }
        InputStream is = super.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        return null;
    }

    private byte[] loadProcessResource(String resourceName) {
        if (this.otherResources == null) {
            return null;
        }
        return this.otherResources.get(resourceName);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.getParent().loadClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("loadClass: " + name + ", result: " + c);
        }
        return c;
    }

    public void release() {
        LogFactory.release((ClassLoader)this);
        if (Misc.isOnWindows()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Releasing class loader: " + this);
            }
            for (URL url : this.urls) {
                try {
                    URLConnection conn = url.openConnection();
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Getting connection of url: " + url + ", conn=" + conn);
                    }
                    String fileURLConnectionClassName = "sun.net.www.protocol.file.FileURLConnection";
                    if (conn instanceof JarURLConnection) {
                        JarFile jarfile = ((JarURLConnection)conn).getJarFile();
                        if (LOG.isLoggable(Level.INFO)) {
                            LOG.info("Closing jar file: " + jarfile.getName());
                        }
                        jarfile.close();
                        continue;
                    }
                    if (!conn.getClass().getName().equals("sun.net.www.protocol.file.FileURLConnection")) continue;
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Closing connection (sun.net.www.protocol.file.FileURLConnection: " + conn);
                    }
                    Method close = conn.getClass().getMethod("close", null);
                    close.invoke((Object)conn, (Object[])null);
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Error while releasing classloader: " + this + ": " + Misc.getStackTraceFrom(e));
                    }
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        try {
            if (Misc.isOnWindows()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Running on Windows. Deactivating cache");
                }
                new URL("http://a").openConnection().setDefaultUseCaches(false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

