/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.element.ConnectorDefinition;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.runtime.CommonClassLoader;
import org.ow2.bonita.runtime.ProcessClassLoader;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassDataLoader {
    private static final Logger LOG = Logger.getLogger(ClassDataLoader.class.getName());
    private static Map<ProcessDefinitionUUID, ProcessClassLoader> processClassLoaders = new HashMap<ProcessDefinitionUUID, ProcessClassLoader>();
    private static CommonClassLoader commonClassloader;
    public static final Object LOCK;

    private ClassDataLoader() {
    }

    public static Class<?> getClass(ProcessDefinitionUUID processUUID, String className) throws ClassNotFoundException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Looking for class " + className + ", in process : " + processUUID);
        }
        Class<?> result = null;
        if (processUUID != null) {
            result = ClassDataLoader.lookIntoProcessClassLoader(processUUID, className);
        }
        if (result != null) {
            return result;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Class " + className + " not found in packageClassLoaders...");
        }
        if ((result = ClassDataLoader.lookIntoCommonClassLoader(className)) != null) {
            return result;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Class " + className + " not found in globalClassLoaders...");
        }
        return ClassDataLoader.class.getClassLoader().loadClass(className);
    }

    public static Object getInstance(ProcessDefinitionUUID processUUID, String className) {
        try {
            Class<?> clazz = ClassDataLoader.getClass(processUUID, className);
            return ClassDataLoader.getClassInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            String message = ExceptionManager.getInstance().getFullMessage("be_CDL_1", className);
            throw new BonitaRuntimeException(message);
        }
    }

    protected static Object getInstance(ProcessDefinitionUUID processUUID, ConnectorDefinition connector) {
        String className = connector.getClassName();
        return ClassDataLoader.getInstance(processUUID, className);
    }

    private static Object getClassInstance(Class<?> clazz) {
        Object obj = ReflectUtil.newInstance(clazz);
        if (obj == null) {
            String message = ExceptionManager.getInstance().getFullMessage("be_CDL_2", clazz.getName());
            throw new BonitaRuntimeException(message);
        }
        return obj;
    }

    private static Class<?> lookIntoProcessClassLoader(ProcessDefinitionUUID processUUID, String className) {
        ClassLoader classLoader = ClassDataLoader.getProcessClassLoader(processUUID);
        try {
            Class<?> result = classLoader.loadClass(className);
            if (result == null) break block4;
            if (result.getClassLoader().equals(classLoader)) {
                return result;
            }
        }
        finally {
            return null;
        }
        {
            block4: {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> lookIntoCommonClassLoader(String className) {
        try {
            ClassDataLoader.initCommonClassloader();
            Object object = LOCK;
            synchronized (object) {
                return commonClassloader.loadClass(className);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initCommonClassloader() {
        Object object = LOCK;
        synchronized (object) {
            if (commonClassloader == null) {
                commonClassloader = new CommonClassLoader();
            }
        }
    }

    public static ClassLoader getProcessClassLoader(ProcessDefinitionUUID processUUID) {
        if (!processClassLoaders.containsKey(processUUID)) {
            processClassLoaders.put(processUUID, new ProcessClassLoader(processUUID));
        }
        return processClassLoaders.get(processUUID);
    }

    public static <T> T getInstance(Class<T> clazz, ProcessDefinitionUUID processUUID, ConnectorDefinition connector) {
        Misc.checkArgsNotNull(clazz, connector);
        Object obj = ClassDataLoader.getInstance(processUUID, connector);
        if (obj == null) {
            String className = connector.getClassName();
            String message = ExceptionManager.getInstance().getFullMessage("be_CDL_3", className);
            throw new BonitaRuntimeException(message);
        }
        if (obj.getClass().isAssignableFrom(clazz)) {
            String message = ExceptionManager.getInstance().getFullMessage("be_CDL_4", connector, clazz.getName(), obj);
            throw new BonitaRuntimeException(message);
        }
        return (T)obj;
    }

    public static void removeProcessClassLoader(ProcessDefinitionUUID processUUID) {
        ProcessClassLoader loader = processClassLoaders.remove(processUUID);
        if (loader != null) {
            loader.release();
        }
    }

    public static void clear() {
        for (ProcessClassLoader loader : processClassLoaders.values()) {
            loader.release();
        }
        processClassLoaders.clear();
        ClassDataLoader.cleanCommonClassLoader();
    }

    public static Set<ProcessDefinitionUUID> getActiveProcessClassLoaders() {
        return processClassLoaders.keySet();
    }

    public static ClassLoader getCommonClassLoader() {
        ClassDataLoader.initCommonClassloader();
        return commonClassloader;
    }

    public static void cleanCommonClassLoader() {
        if (commonClassloader != null) {
            commonClassloader.release();
            commonClassloader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCommonClassloader() {
        Object object = LOCK;
        synchronized (object) {
            commonClassloader = new CommonClassLoader();
        }
    }

    static {
        LOCK = new Object();
    }
}

