/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.runtime.AbstractClassLoader;
import org.ow2.bonita.util.Misc;

public final class CommonClassLoader
extends AbstractClassLoader {
    private static final Logger LOG = Logger.getLogger(CommonClassLoader.class.getName());
    private static CommonClassLoader commonClassLoader;

    CommonClassLoader() {
        super(Misc.getGlobalClassDataCategories(), CommonClassLoader.class.getClassLoader());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating a new CommonClassLoader...");
        }
        if (commonClassLoader != null) {
            commonClassLoader.release();
            commonClassLoader = null;
        }
        commonClassLoader = this;
    }

    public static synchronized CommonClassLoader getCommonClassLoader() {
        if (commonClassLoader == null) {
            commonClassLoader = new CommonClassLoader();
        }
        return commonClassLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VirtualCommonClassLoader
    extends ClassLoader {
        private static VirtualCommonClassLoader current = new VirtualCommonClassLoader();

        public VirtualCommonClassLoader() {
            super(VirtualCommonClassLoader.class.getClassLoader());
        }

        public static ClassLoader get() {
            return current;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return CommonClassLoader.getCommonClassLoader().loadClass(name, resolve);
        }
    }
}

