/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.cal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duration
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean isBusinessTime;
    protected int millis;
    protected int seconds;
    protected int minutes;
    protected int hours;
    protected int days;
    protected int weeks;
    protected int months;
    protected int years;
    private static final Map<String, FieldSetter> fieldSetters = new HashMap<String, FieldSetter>();

    protected Duration() {
    }

    public Duration(String text) {
        if (text == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_Dura_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        for (String part : this.splitInParts(text)) {
            this.parsePart(part);
        }
        this.isBusinessTime = text.indexOf("business") != -1;
    }

    public Duration(boolean isBusinessTime, int millis, int seconds, int minutes, int hours, int days, int weeks, int months, int years) {
        this.isBusinessTime = isBusinessTime;
        this.millis = millis;
        this.seconds = seconds;
        this.minutes = minutes;
        this.hours = hours;
        this.days = days;
        this.weeks = weeks;
        this.months = months;
        this.years = years;
    }

    private List<String> splitInParts(String text) {
        ArrayList<String> parts = new ArrayList<String>(2);
        while (text != null) {
            String part;
            int commaIndex = text.indexOf(44);
            int andIndex = text.indexOf(" and ");
            if (commaIndex == -1 && andIndex != -1 || commaIndex != -1 && andIndex != -1 && andIndex < commaIndex) {
                part = text.substring(0, andIndex).trim();
                parts.add(part);
                text = text.substring(andIndex + 5);
                continue;
            }
            if (commaIndex != -1 && andIndex == -1 || commaIndex != -1 && andIndex != -1 && andIndex > commaIndex) {
                part = text.substring(0, commaIndex).trim();
                parts.add(part);
                text = text.substring(commaIndex + 1);
                continue;
            }
            parts.add(text.trim());
            text = null;
        }
        return parts;
    }

    private void parsePart(String part) {
        int quantity;
        int spaceIndex = part.indexOf(32);
        if (spaceIndex == -1) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_Dura_2", part);
            throw new BonitaRuntimeException(message);
        }
        String quantityText = part.substring(0, spaceIndex).trim();
        spaceIndex = part.lastIndexOf(32);
        String unitText = part.substring(spaceIndex + 1).trim().toLowerCase();
        try {
            quantity = Integer.parseInt(quantityText);
        }
        catch (NumberFormatException e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_Dura_3", quantityText);
            throw new BonitaRuntimeException(message, e);
        }
        FieldSetter fieldSetter = fieldSetters.get(unitText);
        if (fieldSetter == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_Dura_4", quantityText);
            throw new BonitaRuntimeException(message);
        }
        fieldSetter.set(this, quantity);
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public boolean isBusinessTime() {
        return this.isBusinessTime;
    }

    public int getMillis() {
        return this.millis;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getMonths() {
        return this.months;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public int getYears() {
        return this.years;
    }

    static {
        FieldSetter fieldSetter = new MillisSetter();
        fieldSetters.put("milli", fieldSetter);
        fieldSetters.put("millis", fieldSetter);
        fieldSetters.put("millisecond", fieldSetter);
        fieldSetters.put("milliseconds", fieldSetter);
        fieldSetter = new SecondSetter();
        fieldSetters.put("s", fieldSetter);
        fieldSetters.put("sec", fieldSetter);
        fieldSetters.put("second", fieldSetter);
        fieldSetters.put("seconds", fieldSetter);
        fieldSetter = new MinuteSetter();
        fieldSetters.put("min", fieldSetter);
        fieldSetters.put("minute", fieldSetter);
        fieldSetters.put("minutes", fieldSetter);
        fieldSetter = new HourSetter();
        fieldSetters.put("h", fieldSetter);
        fieldSetters.put("hour", fieldSetter);
        fieldSetters.put("hours", fieldSetter);
        fieldSetter = new DaySetter();
        fieldSetters.put("d", fieldSetter);
        fieldSetters.put("day", fieldSetter);
        fieldSetters.put("days", fieldSetter);
        fieldSetter = new WeekSetter();
        fieldSetters.put("w", fieldSetter);
        fieldSetters.put("week", fieldSetter);
        fieldSetters.put("weeks", fieldSetter);
        fieldSetter = new MonthSetter();
        fieldSetters.put("month", fieldSetter);
        fieldSetters.put("months", fieldSetter);
        fieldSetter = new YearSetter();
        fieldSetters.put("y", fieldSetter);
        fieldSetters.put("year", fieldSetter);
        fieldSetters.put("years", fieldSetter);
    }

    private static class YearSetter
    implements FieldSetter {
        private YearSetter() {
        }

        public void set(Duration duration, int quantity) {
            duration.years = quantity;
        }
    }

    private static class MonthSetter
    implements FieldSetter {
        private MonthSetter() {
        }

        public void set(Duration duration, int quantity) {
            duration.months = quantity;
        }
    }

    private static class WeekSetter
    implements FieldSetter {
        private WeekSetter() {
        }

        public void set(Duration duration, int quantity) {
            duration.weeks = quantity;
        }
    }

    private static class DaySetter
    implements FieldSetter {
        private DaySetter() {
        }

        public void set(Duration duration, int quantity) {
            duration.days = quantity;
        }
    }

    private static class HourSetter
    implements FieldSetter {
        private HourSetter() {
        }

        public void set(Duration duration, int quantity) {
            duration.hours = quantity;
        }
    }

    private static class MinuteSetter
    implements FieldSetter {
        private MinuteSetter() {
        }

        public void set(Duration duration, int quantity) {
            duration.minutes = quantity;
        }
    }

    private static class SecondSetter
    implements FieldSetter {
        private SecondSetter() {
        }

        public void set(Duration duration, int quantity) {
            duration.seconds = quantity;
        }
    }

    private static class MillisSetter
    implements FieldSetter {
        private MillisSetter() {
        }

        public void set(Duration duration, int quantity) {
            duration.millis = quantity;
        }
    }

    private static interface FieldSetter {
        public void set(Duration var1, int var2);
    }
}

