/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.Transaction;
import org.ow2.bonita.runtime.event.EventAddedNotification;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventCoupleExceptionHandler
implements Synchronization,
Command<Object> {
    private static final Logger LOG = Logger.getLogger(EventCoupleExceptionHandler.class.getName());
    private static final long serialVersionUID = 1L;
    protected CommandService commandService;
    protected EventCoupleId eventCouple;
    protected Throwable exception;

    public EventCoupleExceptionHandler(EventCoupleId eventCouple, Throwable exception, CommandService commandService) {
        this.commandService = commandService;
        this.eventCouple = eventCouple;
        this.exception = exception;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        LOG.severe("starting new transaction for handling event couple exception");
        this.commandService.execute(this);
        LOG.severe("completed transaction for handling event couple exception");
    }

    @Override
    public Object execute(Environment environment) throws Exception {
        Execution execution;
        EventService eventService = EnvTool.getEventService();
        Querier journal = EnvTool.getJournalQueriers();
        EventExecutor eventExecutor = EnvTool.getEventExecutor();
        IncomingEventInstance incoming = eventService.getIncomingEvent(this.eventCouple.getIncoming());
        String executionEventUUID = incoming.getExecutionUUID();
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        if (executionEventUUID != null && (execution = journal.getExecutionWithEventUUID(executionEventUUID)) != null && incoming.isExecutionLocked()) {
            if (!Execution.STATE_ACTIVE.equals(execution.getState())) {
                execution.unlock();
            }
            execution.lock(execution.getState());
        }
        int decrementedRetries = incoming.getRetries() - 1;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Decrementing retries on incoming: " + incoming + ": " + decrementedRetries);
        }
        incoming.setRetries(decrementedRetries);
        incoming.setException(sw.toString());
        Transaction transaction = environment.get(Transaction.class);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("registering event executor notifier with " + transaction);
        }
        transaction.registerSynchronization(new EventAddedNotification(eventExecutor));
        return null;
    }
}

