/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.runtime.event.EventDispatcherThread;
import org.ow2.bonita.runtime.event.GetNextDueDateCmd;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventExecutor
implements Serializable {
    private static final Logger LOG = Logger.getLogger(EventExecutor.class.getName());
    private static final long serialVersionUID = 1L;
    CommandService commandService;
    int nbrOfThreads = 3;
    int idleMillis = 5000;
    int lockMillis = 1800000;
    int minimumInterval = 50;
    String name = EventExecutor.class.getSimpleName() + "-" + Misc.getHostName();
    private ExecutorService threadPool;
    private EventDispatcherThread dispatcherThread = null;
    private boolean isActive = false;
    Command<Long> nextDueDateCommand;

    public synchronized void start() {
        if (this.isActive) {
            LOG.severe("Cannot start event executor '" + this.name + "' because it is already running...");
            return;
        }
        if (!this.isActive) {
            this.nextDueDateCommand = new GetNextDueDateCmd();
            this.isActive = true;
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("starting event executor threads for event executor '" + this.name + "'...");
            }
            this.threadPool = new ThreadPoolExecutor(this.nbrOfThreads, this.nbrOfThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.nbrOfThreads), EventRejectionHandler.INSTANCE);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("starting dispatcher thread for event executor '" + this.name + "'...");
            }
            this.dispatcherThread = new EventDispatcherThread(this);
            this.dispatcherThread.start();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void refresh() {
        if (this.dispatcherThread != null && this.dispatcherThread.isActive()) {
            this.dispatcherThread.refresh();
        }
    }

    public void notifyThreadFinished() {
        if (this.dispatcherThread != null && this.dispatcherThread.isActive()) {
            this.dispatcherThread.notifyThreadFinished();
        }
    }

    public synchronized void stop() {
        this.stop(false);
    }

    public synchronized void stop(boolean join) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("stopping event executor");
        }
        if (this.isActive) {
            this.isActive = false;
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: deactivating dispatcher thread...");
            }
            this.dispatcherThread.deactivate(true);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: dispatcher thread deactivated...");
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: shutdown threadpool...");
            }
            this.threadPool.shutdown();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: threadpool shutdowned...");
            }
            if (join) {
                try {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Event executor: waiting for threadPool termination...");
                    }
                    this.threadPool.awaitTermination(300000L, TimeUnit.MILLISECONDS);
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Event executor: threadPool termination OK...");
                    }
                }
                catch (InterruptedException e) {
                    LOG.severe("joining got interrupted");
                }
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ignoring stop: event executor '" + this.name + "' not started");
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Event executor stopped");
        }
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public int getIdleMillis() {
        return this.idleMillis;
    }

    public int getLockMillis() {
        return this.lockMillis;
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public Command<Long> getNextDueDateCommand() {
        return this.nextDueDateCommand;
    }

    public int getMinimumInterval() {
        return this.minimumInterval;
    }

    static final class EventRejectionHandler
    implements RejectedExecutionHandler {
        static final EventRejectionHandler INSTANCE = new EventRejectionHandler();

        EventRejectionHandler() {
        }

        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("queuing " + task + " got interrupted", e);
            }
        }
    }
}

