/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Set;
import java.util.logging.Logger;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.ExecuteEventsCouplesCommand;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventExecutorThread
implements Runnable {
    private static final Logger LOG = Logger.getLogger(EventExecutorThread.class.getName());
    private EventExecutor eventExecutor;
    private final Set<EventCoupleId> eventCouples;

    public EventExecutorThread(EventExecutor eventExecutor, Set<EventCoupleId> eventCouples) {
        this.eventExecutor = eventExecutor;
        this.eventCouples = eventCouples;
    }

    @Override
    public void run() {
        try {
            for (EventCoupleId eventCouple : this.eventCouples) {
                this.eventExecutor.getCommandService().execute(new ExecuteEventsCouplesCommand(eventCouple, this.eventExecutor));
            }
        }
        catch (Throwable e) {
            LOG.severe("exception in event block: " + Misc.getStackTraceFrom(e));
        }
        this.eventExecutor.notifyThreadFinished();
    }

    public String toString() {
        return EventExecutorThread.class.getSimpleName() + this.eventCouples;
    }
}

