/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.Transaction;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventCoupleExceptionHandler;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteEventsCouplesCommand
implements Command<Void> {
    private static final Logger LOG = Logger.getLogger(ExecuteEventsCouplesCommand.class.getName());
    private static final long serialVersionUID = -479276850307735480L;
    private EventCoupleId eventCouple;
    private EventExecutor eventExecutor;

    public ExecuteEventsCouplesCommand(EventCoupleId eventCouple, EventExecutor eventExecutor) {
        this.eventCouple = eventCouple;
        this.eventExecutor = eventExecutor;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        OutgoingEventInstance outgoing = null;
        IncomingEventInstance incoming = null;
        try {
            EventService eventService = EnvTool.getEventService();
            outgoing = eventService.getOutgoingEvent(this.eventCouple.getOutgoing());
            incoming = eventService.getIncomingEvent(this.eventCouple.getIncoming());
            if (incoming != null && outgoing != null) {
                if (incoming.isPermanent()) {
                    ProcessDefinitionUUID processUUID = incoming.getActivityDefinitionUUID().getProcessUUID();
                    Authentication.setUserId("SYSTEM");
                    ProcessInstanceUUID instanceUUID = new StandardAPIAccessorImpl().getRuntimeAPI().instantiateProcess(processUUID);
                    outgoing.setLockOwner(instanceUUID.toString());
                    incoming.setLockOwner(null);
                    IncomingEventInstance newIncoming = eventService.getIncomingEvent(instanceUUID, incoming.getName());
                    this.executeEventCouple(newIncoming, outgoing);
                } else {
                    this.executeEventCouple(incoming, outgoing);
                }
            }
        }
        catch (Throwable exception) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Exception caught while executing eventCouple: " + exception + ". Exception: " + exception.getMessage());
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("handling events, incoming: " + incoming + ", outgoing: " + outgoing + " exception: " + exception.getMessage());
            }
            this.handleException(environment, this.eventCouple, exception);
        }
        return null;
    }

    private void executeEventCouple(IncomingEventInstance incoming, OutgoingEventInstance outgoing) {
        Querier journal = EnvTool.getJournalQueriers();
        Execution execution = journal.getExecutionWithEventUUID(incoming.executionUUID);
        if (execution == null) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("No active execution found for uuid: " + incoming.getExecutionUUID());
            }
            throw new BonitaRuntimeException("No active execution found for uuid: " + incoming.getExecutionUUID());
        }
        String signal = incoming.getSignal();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Execution found for uuid: " + incoming.getExecutionUUID());
        }
        Map<String, Object> parameters = outgoing.getParameters();
        if (incoming.isExecutionLocked() && !Execution.STATE_ACTIVE.equals(execution.getState())) {
            execution.unlock();
        }
        EventService eventService = EnvTool.getEventService();
        eventService.removeEvent(outgoing);
        eventService.removeEvent(incoming);
        execution.signal(signal, parameters);
    }

    protected void handleException(Environment environment, EventCoupleId eventCouple, Throwable exception) {
        Transaction transaction = environment.get(Transaction.class);
        EventCoupleExceptionHandler handler = new EventCoupleExceptionHandler(eventCouple, exception, this.eventExecutor.getCommandService());
        transaction.registerSynchronization(handler);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new BonitaRuntimeException("Execution of event couple (" + eventCouple + ") failed: " + exception.getMessage(), exception);
    }
}

