/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetEventsCouplesCommand
implements Command<Set<EventCoupleId>> {
    private static final long serialVersionUID = -479276850307735480L;
    static final Logger LOG = Logger.getLogger(GetEventsCouplesCommand.class.getName());

    @Override
    public Set<EventCoupleId> execute(Environment environment) throws Exception {
        EventService eventService = EnvTool.getEventService();
        Set<EventCouple> eventCouples = eventService.getEventsCouples();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Found eventCouples in DB " + eventCouples);
        }
        if (eventCouples != null && !eventCouples.isEmpty()) {
            OutgoingEventInstance outgoing;
            IncomingEventInstance incoming;
            HashSet<EventCouple> validCouples = new HashSet<EventCouple>();
            HashSet<Long> usedIncomings = new HashSet<Long>();
            HashSet<Long> usedOutgoings = new HashSet<Long>();
            for (EventCouple eventCouple : eventCouples) {
                if (usedIncomings.contains(eventCouple.getIncoming().getId()) || usedOutgoings.contains(eventCouple.getOutgoing().getId())) continue;
                boolean match = true;
                incoming = eventCouple.getIncoming();
                outgoing = eventCouple.getOutgoing();
                String expression = incoming.getExpression();
                Map<String, Object> parameters = outgoing.getParameters();
                if (expression != null) {
                    String groovyExpression = "${" + expression + "}";
                    ActivityInstanceUUID activityUUID = incoming.getActivityUUID();
                    match = activityUUID != null ? ((Boolean)GroovyUtil.evaluate(groovyExpression, parameters, activityUUID, false, false)).booleanValue() : ((Boolean)GroovyUtil.evaluate(groovyExpression, parameters)).booleanValue();
                }
                if (!match) continue;
                usedIncomings.add(incoming.getId());
                usedOutgoings.add(outgoing.getId());
                validCouples.add(eventCouple);
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.info("Adding eventCouple:[incoming=" + incoming.getId() + ", outgoing=" + outgoing.getId() + "] to the queue");
            }
            if (validCouples.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<EventCoupleId> result = new HashSet<EventCoupleId>();
            for (EventCouple eventCouple : validCouples) {
                incoming = eventCouple.getIncoming();
                outgoing = eventCouple.getOutgoing();
                result.add(new EventCoupleId(incoming.getId(), outgoing.getId()));
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("New event couples to execute: " + ((Object)result).toString());
            }
            return result;
        }
        return null;
    }
}

