/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.tx;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.ow2.bonita.runtime.tx.StandardResource;

public class HibernateSessionResource
implements StandardResource {
    static final Logger LOG = Logger.getLogger(HibernateSessionResource.class.getName());
    protected Session session;
    protected Transaction transaction;

    public HibernateSessionResource(Session session) {
        this.session = session;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("beginning transaction on hibernate session " + System.identityHashCode(session));
        }
        try {
            this.transaction = session.beginTransaction();
        }
        catch (RuntimeException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("hibernate transaction begin failed.  closing hibernate session: " + e);
            }
            session.close();
            throw e;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("begun hibernate transaction " + System.identityHashCode(this.transaction) + " on hibernate session " + System.identityHashCode(session));
        }
    }

    public void prepare() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("flushing hibernate session " + System.identityHashCode(this.session));
        }
        this.session.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("committing hibernate transaction " + System.identityHashCode(this.transaction));
        }
        try {
            this.transaction.commit();
        }
        finally {
            this.closeSession();
        }
    }

    private void closeSession() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("closing hibernate session " + System.identityHashCode(this.session));
        }
        this.session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("rolling back hibernate transaction " + System.identityHashCode(this.transaction));
        }
        try {
            this.transaction.rollback();
        }
        finally {
            this.closeSession();
        }
    }
}

