/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.tx;

import org.ow2.bonita.env.Environment;
import org.ow2.bonita.runtime.tx.StandardTransaction;
import org.ow2.bonita.services.impl.Interceptor;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTransactionInterceptor
extends Interceptor {
    @Override
    public <T> T execute(Command<T> command) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_STI_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        StandardTransaction standardTransaction = environment.get(StandardTransaction.class);
        if (standardTransaction == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_STI_2", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        standardTransaction.begin();
        try {
            T message = this.next.execute(command);
            return message;
        }
        catch (RuntimeException e) {
            standardTransaction.setRollbackOnly();
            throw e;
        }
        finally {
            standardTransaction.complete();
        }
    }
}

