/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.persistence.QuerierDbSession;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDbQuerier
implements Querier {
    private String persistenceServiceName;

    public AbstractDbQuerier(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected String getPersistenceServiceName() {
        return this.persistenceServiceName;
    }

    protected QuerierDbSession getDbSession() {
        return EnvTool.getQuerierDbSession(this.persistenceServiceName);
    }

    @Override
    public int getNumberOfProcesses() {
        return this.getDbSession().getNumberOfProcesses();
    }

    @Override
    public int getNumberOfParentProcessInstances() {
        return this.getDbSession().getNumberOfParentProcessInstances();
    }

    @Override
    public int getNumberOfProcessInstances() {
        return this.getDbSession().getNumberOfProcessInstances();
    }

    @Override
    public InternalActivityDefinition getActivity(ActivityDefinitionUUID activityDefinitionUUID) {
        Misc.checkArgsNotNull(activityDefinitionUUID);
        return this.getDbSession().getActivityDefinition(activityDefinitionUUID);
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityName) {
        Misc.checkArgsNotNull(instanceUUID, activityName);
        Set<InternalActivityInstance> activityInstances = this.getDbSession().getActivityInstances(instanceUUID, activityName);
        if (activityInstances != null) {
            return activityInstances;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID, String activityName, String iterationId) {
        Misc.checkArgsNotNull(instanceUUID, activityName, iterationId);
        Set<InternalActivityInstance> activityInstances = this.getDbSession().getActivityInstances(instanceUUID, activityName, iterationId);
        if (activityInstances != null) {
            return activityInstances;
        }
        return Collections.emptySet();
    }

    @Override
    public InternalActivityInstance getActivityInstance(ProcessInstanceUUID instanceUUID, String activityName, String iterationId, String activityInstanceId) {
        return this.getDbSession().getActivityInstance(instanceUUID, activityName, iterationId, activityInstanceId);
    }

    @Override
    public ActivityState getActivityInstanceState(ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        return this.getDbSession().getActivityInstanceState(activityInstanceUUID);
    }

    @Override
    public InternalActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        return this.getDbSession().getActivityInstance(activityInstanceUUID);
    }

    @Override
    public Set<InternalActivityInstance> getActivityInstances(ProcessInstanceUUID instanceUUID) {
        Misc.checkArgsNotNull(instanceUUID);
        Set<InternalActivityInstance> activityInstances = this.getDbSession().getActivityInstances(instanceUUID);
        if (activityInstances != null) {
            return activityInstances;
        }
        return new HashSet<InternalActivityInstance>();
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(ProcessInstanceUUID rootInstanceUUID) {
        Misc.checkArgsNotNull(rootInstanceUUID);
        return this.getDbSession().getActivityInstancesFromRoot(rootInstanceUUID);
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs) {
        Misc.checkArgsNotNull(rootInstanceUUIDs);
        return this.getDbSession().getActivityInstancesFromRoot(rootInstanceUUIDs);
    }

    @Override
    public List<InternalActivityInstance> getActivityInstancesFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, ActivityState state) {
        Misc.checkArgsNotNull(new Object[]{rootInstanceUUIDs, state});
        return this.getDbSession().getActivityInstancesFromRoot(rootInstanceUUIDs, state);
    }

    @Override
    public Map<ProcessInstanceUUID, InternalActivityInstance> getLastUpdatedActivityInstanceFromRoot(Set<ProcessInstanceUUID> rootInstanceUUIDs, boolean considerSystemTaks) {
        Misc.checkArgsNotNull(rootInstanceUUIDs);
        return this.getDbSession().getLastUpdatedActivityInstanceFromRoot(rootInstanceUUIDs, considerSystemTaks);
    }

    @Override
    public InternalProcessInstance getProcessInstance(ProcessInstanceUUID instanceUUID) {
        Misc.checkArgsNotNull(instanceUUID);
        return this.getDbSession().getProcessInstance(instanceUUID);
    }

    @Override
    public Set<ProcessInstanceUUID> getParentInstancesUUIDs() {
        Set<InternalProcessInstance> parentInstances = this.getParentInstances();
        HashSet<ProcessInstanceUUID> result = new HashSet<ProcessInstanceUUID>();
        for (InternalProcessInstance instance : parentInstances) {
            result.add(instance.getUUID());
        }
        return result;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances() {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstances();
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int fromIndex, int pageSize) {
        List<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstances(instanceUUIDs, fromIndex, pageSize);
        if (dbInstances == null) {
            return Collections.emptyList();
        }
        return dbInstances;
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessInstances(int maxResults, long time) {
        return this.getDbSession().getMostRecentProcessInstances(maxResults, time);
    }

    @Override
    public List<InternalProcessInstance> getMostRecentParentProcessInstances(int maxResults, long time) {
        return this.getDbSession().getMostRecentParentProcessInstances(maxResults, time);
    }

    @Override
    public List<InternalProcessInstance> getMostRecentMatchingProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs, int maxResults, long time) {
        return this.getDbSession().getMostRecentMatchingProcessInstances(instanceUUIDs, maxResults, time);
    }

    @Override
    public List<InternalProcessInstance> getMostRecentProcessesProcessInstances(Collection<ProcessDefinitionUUID> definitionUUIDs, int maxResults, long time) {
        return this.getDbSession().getMostRecentProcessesProcessInstances(definitionUUIDs, maxResults, time);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(int fromIndex, int pageSize) {
        return this.getDbSession().getProcesses(fromIndex, pageSize);
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(int fromIndex, int pageSize) {
        return this.getDbSession().getProcessInstances(fromIndex, pageSize);
    }

    @Override
    public List<InternalProcessInstance> getParentProcessInstances(int fromIndex, int pageSize) {
        return this.getDbSession().getParentProcessInstances(fromIndex, pageSize);
    }

    @Override
    public Set<InternalProcessInstance> getParentInstances() {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getParentInstances();
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(Collection<ProcessInstanceUUID> instanceUUIDs) {
        if (instanceUUIDs == null || instanceUUIDs.isEmpty()) {
            return Collections.emptySet();
        }
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstances(instanceUUIDs);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID, InstanceState instanceState) {
        Misc.checkArgsNotNull(processUUID);
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstances(processUUID, instanceState);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    private Execution getExecOnNode(Execution exec, ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(exec, activityInstanceUUID);
        if (exec.getExecutions() == null || exec.getExecutions().isEmpty()) {
            if (exec.getNode() != null && exec.getActivityInstanceUUID() != null && exec.getActivityInstanceUUID().equals(activityInstanceUUID)) {
                return exec;
            }
        } else {
            for (Execution child : exec.getExecutions()) {
                Execution found = this.getExecOnNode(child, activityInstanceUUID);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    @Override
    public Execution getExecutionOnActivity(ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID) {
        Misc.checkArgsNotNull(instanceUUID, activityUUID);
        InternalProcessInstance instance = this.getProcessInstance(instanceUUID);
        if (instance != null) {
            return this.getExecOnNode(instance.getRootExecution(), activityUUID);
        }
        return this.getDbSession().getExecutionPointingOnNode(activityUUID);
    }

    @Override
    public Set<Execution> getExecutions(ProcessInstanceUUID instanceUUID) {
        Misc.checkArgsNotNull(instanceUUID);
        return this.getDbSession().getExecutions(instanceUUID);
    }

    @Override
    public Execution getExecutionWithEventUUID(String eventUUID) {
        Misc.checkArgsNotNull(eventUUID);
        return this.getDbSession().getExecutionWithEventUUID(eventUUID);
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getUserInstances(userId);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId, Date minStartDate) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getUserInstances(userId, minStartDate);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getUserParentInstances(String userId, Date minStartDate) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getUserParentInstances(userId, minStartDate);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getUserInstancesExcept(String userId, Set<ProcessInstanceUUID> myCases) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getUserInstancesExcept(userId, myCases);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstancesWithTaskState(activityStates);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstancesWithInstanceStates(instanceStates);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(ProcessDefinitionUUID processUUID) {
        Misc.checkArgsNotNull(processUUID);
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstances(processUUID);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getUpdatedWebProcessInstances(String user, int fromIndex, int pageSize) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getUpdatedWebProcessInstances(user, fromIndex, pageSize);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public InternalProcessDefinition getProcess(String processId, String version) {
        Misc.checkArgsNotNull(processId, version);
        return this.getDbSession().getProcess(processId, version);
    }

    @Override
    public InternalProcessDefinition getProcess(ProcessDefinitionUUID processUUID) {
        Misc.checkArgsNotNull(processUUID);
        return this.getDbSession().getProcess(processUUID);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses() {
        Set<InternalProcessDefinition> processes = this.getDbSession().getProcesses();
        if (processes == null) {
            return Collections.emptySet();
        }
        return processes;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(String processId) {
        Misc.checkArgsNotNull(processId);
        Set<InternalProcessDefinition> processes = this.getDbSession().getProcesses(processId);
        if (processes == null) {
            return Collections.emptySet();
        }
        return processes;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(ProcessDefinition.ProcessState processState) {
        Misc.checkArgsNotNull(new Object[]{processState});
        Set<InternalProcessDefinition> processes = this.getDbSession().getProcesses(processState);
        if (processes == null) {
            return Collections.emptySet();
        }
        return processes;
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(String processId, ProcessDefinition.ProcessState processState) {
        Misc.checkArgsNotNull(new Object[]{processId, processState});
        Set<InternalProcessDefinition> processes = this.getDbSession().getProcesses(processId, processState);
        if (processes == null) {
            return Collections.emptySet();
        }
        return processes;
    }

    @Override
    public TaskInstance getTaskInstance(ActivityInstanceUUID taskUUID) {
        Misc.checkArgsNotNull(taskUUID);
        return this.getDbSession().getTaskInstance(taskUUID);
    }

    @Override
    public Set<TaskInstance> getTaskInstances(ProcessInstanceUUID instanceUUID) {
        Misc.checkArgsNotNull(instanceUUID);
        Set<TaskInstance> tasks = this.getDbSession().getTaskInstances(instanceUUID);
        if (tasks == null) {
            return Collections.emptySet();
        }
        return tasks;
    }

    @Override
    public Set<TaskInstance> getUserInstanceTasks(String userId, ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        Misc.checkArgsNotNull(new Object[]{userId, instanceUUID, taskState});
        Set<TaskInstance> tasks = this.getDbSession().getUserInstanceTasks(userId, instanceUUID, taskState);
        if (tasks == null) {
            return Collections.emptySet();
        }
        return tasks;
    }

    @Override
    public TaskInstance getOneTask(String userId, ProcessDefinitionUUID processUUID, ActivityState taskState) {
        return this.getDbSession().getOneTask(userId, processUUID, taskState);
    }

    @Override
    public TaskInstance getOneTask(String userId, ProcessInstanceUUID instanceUUID, ActivityState taskState) {
        return this.getDbSession().getOneTask(userId, instanceUUID, taskState);
    }

    @Override
    public TaskInstance getOneTask(String userId, ActivityState taskState) {
        return this.getDbSession().getOneTask(userId, taskState);
    }

    @Override
    public Set<TaskInstance> getUserTasks(String userId, ActivityState taskState) {
        HashSet<ActivityState> taskStates = new HashSet<ActivityState>();
        taskStates.add(taskState);
        return this.getUserTasks(userId, taskStates);
    }

    @Override
    public Set<TaskInstance> getUserTasks(String userId, Collection<ActivityState> taskStates) {
        Misc.checkArgsNotNull(userId, taskStates);
        Set<TaskInstance> tasks = this.getDbSession().getUserTasks(userId, taskStates);
        if (tasks == null) {
            return Collections.emptySet();
        }
        return tasks;
    }

    @Override
    public Set<InternalProcessDefinition> getDependentProcesses(ProcessDefinitionUUID processUUID) {
        Misc.checkArgsNotNull(processUUID);
        Set<InternalProcessDefinition> deps = this.getDbSession().getDependentProcesses(processUUID);
        if (deps == null) {
            return Collections.emptySet();
        }
        return deps;
    }

    @Override
    public String getLastProcessVersion(String processName) {
        Misc.checkArgsNotNull(processName);
        return this.getDbSession().getLastProcessVersion(processName);
    }

    @Override
    public long getLastProcessInstanceNb(ProcessDefinitionUUID processUUID) {
        Misc.checkArgsNotNull(processUUID);
        return this.getDbSession().getLastProcessInstanceNb(processUUID);
    }

    @Override
    public InternalProcessDefinition getLastDeployedProcess(String processId, ProcessDefinition.ProcessState processState) {
        Misc.checkArgsNotNull(new Object[]{processId, processState});
        return this.getDbSession().getLastProcess(processId, processState);
    }

    @Override
    public List<Integer> getNumberOfFinishedCasesPerDay(Date since, Date to) {
        return this.getDbSession().getNumberOfFinishedCasesPerDay(since, to);
    }

    @Override
    public List<Integer> getNumberOfExecutingCasesPerDay(Date since, Date to) {
        return this.getDbSession().getNumberOfExecutingCasesPerDay(since, to);
    }

    @Override
    public int getNumberOfOpenSteps() {
        return this.getDbSession().getNumberOfOpenSteps();
    }

    @Override
    public List<Integer> getNumberOfOpenStepsPerDay(Date since, Date to) {
        return this.getDbSession().getNumberOfOpenStepsPerDay(since, to);
    }

    @Override
    public int getNumberOfOverdueSteps(Date currentDate) {
        return this.getDbSession().getNumberOfOverdueSteps(currentDate);
    }

    @Override
    public int getNumberOfStepsAtRisk(Date beginningOfTheDay, Date atRisk) {
        return this.getDbSession().getNumberOfStepsAtRisk(beginningOfTheDay, atRisk);
    }

    @Override
    public int getNumberOfUserOpenSteps(String userId) {
        return this.getDbSession().getNumberOfUserOpenSteps(userId);
    }

    @Override
    public int getNumberOfUserOverdueSteps(String userId, Date currentDate) {
        return this.getDbSession().getNumberOfUserOverdueSteps(userId, currentDate);
    }

    @Override
    public int getNumberOfUserStepsAtRisk(String userId, Date beginningOfTheDay, Date atRisk) {
        return this.getDbSession().getNumberOfUserStepsAtRisk(userId, beginningOfTheDay, atRisk);
    }

    @Override
    public int getNumberOfFinishedSteps(int priority, Date since) {
        return this.getDbSession().getNumberOfFinishedSteps(priority, since);
    }

    @Override
    public int getNumberOfOpenSteps(int priority) {
        return this.getDbSession().getNumberOfOpenSteps(priority);
    }

    @Override
    public int getNumberOfUserFinishedSteps(String userId, int priority, Date since) {
        return this.getDbSession().getNumberOfUserFinishedSteps(userId, priority, since);
    }

    @Override
    public int getNumberOfUserOpenSteps(String userId, int priority) {
        return this.getDbSession().getNumberOfUserOpenSteps(userId, priority);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs) {
        return this.getDbSession().getProcesses(definitionUUIDs);
    }

    @Override
    public Set<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, ProcessDefinition.ProcessState processState) {
        return this.getDbSession().getProcesses(definitionUUIDs, processState);
    }

    @Override
    public List<InternalProcessDefinition> getProcesses(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize) {
        return this.getDbSession().getProcesses(definitionUUIDs, fromIndex, pageSize);
    }

    @Override
    public InternalProcessDefinition getLastDeployedProcess(Set<ProcessDefinitionUUID> definitionUUIDs, ProcessDefinition.ProcessState processState) {
        Misc.checkArgsNotNull(new Object[]{processState});
        return this.getDbSession().getLastProcess(definitionUUIDs, processState);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        return this.getDbSession().getProcessInstances(definitionUUIDs);
    }

    @Override
    public Set<InternalProcessInstance> getUserInstances(String userId, Set<ProcessDefinitionUUID> definitionUUIDs) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getUserInstances(userId, definitionUUIDs);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public int getNumberOfProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        return this.getDbSession().getNumberOfProcessInstances(definitionUUIDs);
    }

    @Override
    public int getNumberOfParentProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs) {
        return this.getDbSession().getNumberOfParentProcessInstances(definitionUUIDs);
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithTaskState(Collection<ActivityState> activityStates, Set<ProcessDefinitionUUID> definitionUUIDs) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstancesWithTaskState(activityStates, definitionUUIDs);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public Set<InternalProcessInstance> getProcessInstancesWithInstanceStates(Collection<InstanceState> instanceStates, Set<ProcessDefinitionUUID> visibleProcessUUIDs) {
        Set<InternalProcessInstance> dbInstances = this.getDbSession().getProcessInstancesWithInstanceStates(instanceStates, visibleProcessUUIDs);
        if (dbInstances == null) {
            return Collections.emptySet();
        }
        return dbInstances;
    }

    @Override
    public TaskInstance getOneTask(String userId, ActivityState taskState, Set<ProcessDefinitionUUID> definitionUUIDs) {
        return this.getDbSession().getOneTask(userId, taskState, definitionUUIDs);
    }

    @Override
    public Set<TaskInstance> getUserTasks(String userId, ActivityState taskState, Set<ProcessDefinitionUUID> definitionUUIDs) {
        HashSet<ActivityState> taskStates = new HashSet<ActivityState>();
        taskStates.add(taskState);
        Set<TaskInstance> userTasks = this.getUserTasks(userId, taskStates);
        HashSet<TaskInstance> filtredTasks = new HashSet<TaskInstance>();
        for (TaskInstance taskInstance : userTasks) {
            if (!definitionUUIDs.contains(taskInstance.getProcessDefinitionUUID())) continue;
            filtredTasks.add(taskInstance);
        }
        return filtredTasks;
    }

    @Override
    public List<InternalProcessInstance> getProcessInstances(Set<ProcessDefinitionUUID> definitionUUIDs, int fromIndex, int pageSize) {
        return this.getDbSession().getProcessInstances(definitionUUIDs, fromIndex, pageSize);
    }

    @Override
    public List<InternalProcessDefinition> getProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize) {
        return this.getDbSession().getProcessesExcept(processUUIDs, fromIndex, pageSize);
    }

    @Override
    public int getNumberOfActivityInstanceComments(ActivityInstanceUUID activityUUID) {
        return this.getDbSession().getNumberOfActivityInstanceComments(activityUUID);
    }

    @Override
    public Map<ActivityInstanceUUID, Integer> getNumberOfActivityInstanceComments(Set<ActivityInstanceUUID> activityUUIDs) {
        return this.getDbSession().getNumberOfActivityInstanceComments(activityUUIDs);
    }

    @Override
    public int getNumberOfComments(ProcessInstanceUUID instanceUUID) {
        return this.getDbSession().getNumberOfComments(instanceUUID);
    }

    @Override
    public List<Comment> getCommentFeed(ProcessInstanceUUID instanceUUID) {
        return this.getDbSession().getCommentFeed(instanceUUID);
    }

    @Override
    public List<Comment> getActivityInstanceCommentFeed(ActivityInstanceUUID activityUUID) {
        return this.getDbSession().getActivityInstanceCommentFeed(activityUUID);
    }

    @Override
    public Set<ProcessDefinitionUUID> getAllProcessDefinitionUUIDsExcept(Set<ProcessDefinitionUUID> processUUIDs) {
        return this.getDbSession().getAllProcessDefinitionUUIDsExcept(processUUIDs);
    }

    @Override
    public Set<ProcessDefinitionUUID> getAllProcessDefinitionUUIDs() {
        return this.getDbSession().getAllProcessDefinitionUUIDs();
    }

    @Override
    public int getNumberOfProcessInstanceComments(ProcessInstanceUUID instanceUUID) {
        return this.getDbSession().getNumberOfProcessInstanceComments(instanceUUID);
    }

    @Override
    public List<Comment> getProcessInstanceCommentFeed(ProcessInstanceUUID instanceUUID) {
        return this.getDbSession().getProcessInstanceCommentFeed(instanceUUID);
    }
}

