/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import org.ow2.bonita.env.Environment;
import org.ow2.bonita.services.impl.AuthorizationSession;
import org.ow2.bonita.services.impl.Interceptor;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationInterceptor
extends Interceptor {
    @Override
    public <T> T execute(Command<T> command) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_AI_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        AuthorizationSession authorizationSession = environment.get(AuthorizationSession.class);
        if (authorizationSession == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_AI_2", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        authorizationSession.checkPermission(command, environment);
        return this.next.execute(command);
    }
}

