/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.persistence.IdentityDbSession;
import org.ow2.bonita.services.AuthenticationService;
import org.ow2.bonita.util.EnvTool;

public class DbAuthentication
implements AuthenticationService {
    private static final Logger LOG = Logger.getLogger(DbAuthentication.class.getName());
    private static final String DEFAULT_ADMIN_ROLE_NAME = "admin";
    private String persistenceServiceName;

    public DbAuthentication(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected IdentityDbSession getDbSession() {
        return EnvTool.getIdentityDbSession(this.persistenceServiceName);
    }

    public boolean isUserAdmin(String username) {
        try {
            UserImpl user = this.getDbSession().getIdentityUser(username);
            if (user == null) {
                throw new UserNotFoundException("bsi_DBA_1", username);
            }
            Set<RoleImpl> userRoles = user.getRoles();
            for (RoleImpl role : userRoles) {
                if (!DEFAULT_ADMIN_ROLE_NAME.equals(role.getName())) continue;
                return true;
            }
            return false;
        }
        catch (UserNotFoundException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e.getCause());
            return false;
        }
    }

    public boolean checkUserCredentials(String username, String password) {
        UserImpl user = this.getDbSession().getIdentityUser(username);
        return user != null && user.getPassword().equals(password);
    }
}

