/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Set;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.services.History;
import org.ow2.bonita.services.impl.AbstractDbQuerier;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class DbHistory
extends AbstractDbQuerier
implements History {
    public DbHistory(String name) {
        super(name);
    }

    public void archive(InternalProcessDefinition process) {
        Misc.checkArgsNotNull(process);
        if (this.getProcess(process.getUUID()) != null) {
            String message = ExceptionManager.getInstance().getFullMessage("bsi_DH_1", process);
            throw new IllegalArgumentException(message);
        }
        this.getDbSession().save(process);
    }

    public void archive(InternalProcessInstance processInst) {
        Misc.checkArgsNotNull(processInst);
        if (this.getProcessInstance(processInst.getUUID()) != null) {
            String message = ExceptionManager.getInstance().getFullMessage("bsi_DH_2", processInst);
            throw new IllegalArgumentException(message);
        }
        this.getDbSession().save(processInst);
    }

    public void remove(InternalProcessDefinition process) {
        Misc.checkArgsNotNull(process);
        this.getDbSession().delete(process);
    }

    public void remove(InternalProcessInstance processInst) {
        Misc.checkArgsNotNull(processInst);
        this.getDbSession().delete(processInst);
    }

    public void clear() {
        Set<InternalProcessDefinition> processes = this.getDbSession().getProcesses();
        for (InternalProcessDefinition processDef : processes) {
            Set<InternalProcessInstance> processInstances = this.getDbSession().getProcessInstances(processDef.getUUID());
            for (InternalProcessInstance processInstance : processInstances) {
                this.getDbSession().delete(processInstance);
            }
            this.getDbSession().delete(processDef);
        }
    }
}

