/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Set;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.persistence.IdentityDbSession;
import org.ow2.bonita.persistence.db.HibernateDbSession;
import org.ow2.bonita.services.IdentityService;
import org.ow2.bonita.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbIdentity
extends HibernateDbSession
implements IdentityService {
    private String persistenceServiceName;

    public DbIdentity(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected IdentityDbSession getDbSession() {
        return EnvTool.getIdentityDbSession(this.persistenceServiceName);
    }

    @Override
    public RoleImpl getRole(String name) {
        return this.getDbSession().getRole(name);
    }

    @Override
    public Set<RoleImpl> getRoles() {
        return this.getDbSession().getRoles();
    }

    @Override
    public UserImpl getUser(String username) {
        return this.getDbSession().getIdentityUser(username);
    }

    @Override
    public Set<UserImpl> getUsers() {
        return this.getDbSession().getIdentityUsers();
    }

    @Override
    public void addRole(RoleImpl role) {
        this.getDbSession().save(role);
    }

    @Override
    public void addUser(UserImpl user) {
        this.getDbSession().save(user);
    }

    @Override
    public void deleteRole(RoleImpl role) {
        this.getDbSession().delete(role);
    }

    @Override
    public void deleteUser(UserImpl user) {
        this.getDbSession().delete(user);
    }
}

