/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Date;
import java.util.Set;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.impl.MetaDataImpl;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.StateUpdate;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.VariableUpdateImpl;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.persistence.JournalDbSession;
import org.ow2.bonita.services.Journal;
import org.ow2.bonita.services.impl.AbstractDbQuerier;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.type.lob.Lob;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.VariableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbJournal
extends AbstractDbQuerier
implements Journal {
    public DbJournal(String persistenceServiceName) {
        super(persistenceServiceName);
    }

    @Override
    protected JournalDbSession getDbSession() {
        return EnvTool.getJournalDbSession(this.getPersistenceServiceName());
    }

    @Override
    public void remove(InternalProcessDefinition pack) {
        Misc.checkArgsNotNull(pack);
        this.getDbSession().delete(pack);
    }

    @Override
    public void remove(InternalProcessInstance processInst) {
        Misc.checkArgsNotNull(processInst);
        this.getDbSession().delete(processInst);
    }

    @Override
    public void recordEnterActivity(ActivityInstance activityInstance) {
        Misc.checkArgsNotNull(activityInstance);
        InternalProcessInstance processInstance = this.getProcessInstance(activityInstance.getProcessInstanceUUID());
        processInstance.addActivity(activityInstance);
    }

    @Override
    public void recordBodyStarted(ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        InternalActivityInstance activityInstance = this.getActivityInstance(activityInstanceUUID);
        if (!activityInstance.isTask()) {
            activityInstance.setActivityState(ActivityState.EXECUTING, "SYSTEM");
        }
    }

    @Override
    public void recordBodyEnded(ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        InternalActivityInstance activityInstance = this.getActivityInstance(activityInstanceUUID);
        if (!activityInstance.isTask()) {
            activityInstance.setActivityState(ActivityState.FINISHED, "SYSTEM");
        }
    }

    @Override
    public void recordBodyAborted(ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        InternalActivityInstance activityInstance = this.getActivityInstance(activityInstanceUUID);
        activityInstance.setActivityState(ActivityState.ABORTED, "SYSTEM");
    }

    @Override
    public void recordBodyCancelled(ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        InternalActivityInstance activityInstance = this.getActivityInstance(activityInstanceUUID);
        activityInstance.setActivityState(ActivityState.CANCELLED, EnvTool.getUserId());
    }

    @Override
    public void recordInstanceEnded(ProcessInstanceUUID instanceUUID, String loggedInUserId) {
        Misc.checkArgsNotNull(instanceUUID);
        InternalProcessInstance instanceRecord = this.getProcessInstance(instanceUUID);
        String message = ExceptionManager.getInstance().getFullMessage("bsi_DJ_1", instanceUUID);
        Misc.badStateIfNull(instanceRecord, message);
        instanceRecord.setInstanceState(InstanceState.FINISHED, loggedInUserId);
    }

    @Override
    public void recordInstanceAborted(ProcessInstanceUUID instanceUUID, String loggedInUserId) {
        Misc.checkArgsNotNull(instanceUUID);
        InternalProcessInstance instanceRecord = this.getProcessInstance(instanceUUID);
        String message = ExceptionManager.getInstance().getFullMessage("bsi_DJ_2", instanceUUID);
        Misc.badStateIfNull(instanceRecord, message);
        instanceRecord.setInstanceState(InstanceState.ABORTED, loggedInUserId);
    }

    @Override
    public void recordInstanceCancelled(ProcessInstanceUUID instanceUUID, String loggedInUserId) {
        Misc.checkArgsNotNull(instanceUUID);
        InternalProcessInstance instanceRecord = this.getProcessInstance(instanceUUID);
        String message = ExceptionManager.getInstance().getFullMessage("bsi_DJ_3", instanceUUID);
        Misc.badStateIfNull(instanceRecord, message);
        instanceRecord.setInstanceState(InstanceState.CANCELLED, loggedInUserId);
    }

    @Override
    public void recordInstanceStarted(InternalProcessInstance instance, String loggedInUserId) {
        Misc.checkArgsNotNull(instance);
        if (instance.getParentInstanceUUID() != null) {
            InternalProcessInstance parentInstance = this.getProcessInstance(instance.getParentInstanceUUID());
            parentInstance.addChildInstance(instance.getUUID());
        }
        String message = ExceptionManager.getInstance().getFullMessage("bsi_DJ_4", new Object[0]);
        Misc.badStateIfNull(loggedInUserId, message);
        instance.setInstanceState(InstanceState.STARTED, loggedInUserId);
        this.getDbSession().save(instance);
    }

    @Override
    public void recordTaskFinished(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        Misc.checkArgsNotNull(taskUUID);
        TaskInstance activity = this.getTaskInstance(taskUUID);
        String message = ExceptionManager.getInstance().getFullMessage("bsi_DJ_5", taskUUID);
        Misc.badStateIfNull(activity, message);
        ((InternalActivityInstance)activity).setActivityState(ActivityState.FINISHED, loggedInUserId);
    }

    @Override
    public void recordTaskReady(ActivityInstanceUUID taskUUID, Set<String> candidates, String userId) {
        Misc.checkArgsNotNull(taskUUID);
        TaskInstance activity = this.getTaskInstance(taskUUID);
        String message = ExceptionManager.getInstance().getFullMessage("bsi_DJ_6", taskUUID);
        Misc.badStateIfNull(activity, message);
        if (userId != null) {
            ((InternalActivityInstance)activity).setTaskAssign(ActivityState.READY, "SYSTEM", userId);
        } else {
            ((InternalActivityInstance)activity).setTaskAssign(ActivityState.READY, "SYSTEM", candidates);
        }
    }

    @Override
    public void recordTaskStarted(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        Misc.checkArgsNotNull(taskUUID);
        TaskInstance activity = this.getTaskInstance(taskUUID);
        String message = ExceptionManager.getInstance().getFullMessage("bsi_DJ_7", taskUUID);
        Misc.badStateIfNull(activity, message);
        ((InternalActivityInstance)activity).setActivityState(ActivityState.EXECUTING, loggedInUserId);
    }

    @Override
    public void recordTaskResumed(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        Misc.checkArgsNotNull(taskUUID);
        TaskInstance task = this.getTaskInstance(taskUUID);
        ActivityState stateBeforeSuspend = null;
        for (StateUpdate su : task.getStateUpdates()) {
            if (!su.getActivityState().equals((Object)ActivityState.SUSPENDED)) continue;
            stateBeforeSuspend = su.getInitialState();
        }
        ((InternalActivityInstance)task).setActivityState(stateBeforeSuspend, loggedInUserId);
    }

    @Override
    public void recordTaskSuspended(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        Misc.checkArgsNotNull(taskUUID);
        TaskInstance activity = this.getTaskInstance(taskUUID);
        ((InternalActivityInstance)activity).setActivityState(ActivityState.SUSPENDED, loggedInUserId);
    }

    @Override
    public void recordTaskAssigned(ActivityInstanceUUID taskUUID, ActivityState taskState, String loggedInUserId, Set<String> candidates, String assignedUserId) {
        Misc.checkArgsNotNull(taskUUID);
        TaskInstance activity = this.getTaskInstance(taskUUID);
        if (assignedUserId != null) {
            ((InternalActivityInstance)activity).setTaskAssign(taskState, loggedInUserId, assignedUserId);
        } else {
            ((InternalActivityInstance)activity).setTaskAssign(taskState, loggedInUserId, candidates);
        }
    }

    @Override
    public void recordProcessDeployed(InternalProcessDefinition processDef, String userId) {
        Misc.checkArgsNotNull(processDef);
        processDef.setState(ProcessDefinition.ProcessState.ENABLED);
        processDef.setDeployedDate(new Date());
        processDef.setDeployedBy(userId);
        this.getDbSession().save(processDef);
    }

    @Override
    public void recordProcessEnable(InternalProcessDefinition processDef) {
        Misc.checkArgsNotNull(processDef);
        processDef.setState(ProcessDefinition.ProcessState.ENABLED);
    }

    @Override
    public void recordProcessDisable(InternalProcessDefinition processDef) {
        Misc.checkArgsNotNull(processDef);
        processDef.setState(ProcessDefinition.ProcessState.DISABLED);
    }

    @Override
    public void recordProcessArchive(InternalProcessDefinition processDef, String userId) {
        Misc.checkArgsNotNull(processDef);
        processDef.setUndeployedBy(userId);
        processDef.setUndeployedDate(new Date());
        processDef.setState(ProcessDefinition.ProcessState.ARCHIVED);
    }

    public void recordProcessUndeployed(InternalProcessDefinition processDef) {
        this.recordProcessDisable(processDef);
    }

    @Override
    public void recordActivityVariableUpdated(String variableId, Object variableValue, ActivityInstanceUUID activityUUID, String userId) {
        Misc.checkArgsNotNull(variableId, activityUUID, userId);
        InternalActivityInstance activityInst = this.getActivityInstance(activityUUID);
        Variable v = VariableUtil.createVariable(activityInst.getProcessDefinitionUUID(), variableId, variableValue);
        VariableUpdateImpl varUpdate = new VariableUpdateImpl(new Date(), userId, variableId, v);
        activityInst.addVariableUpdate(varUpdate);
    }

    @Override
    public void recordInstanceVariableUpdated(String variableId, Object variableValue, ProcessInstanceUUID instanceUUID, String userId) {
        Misc.checkArgsNotNull(variableId, instanceUUID, userId);
        InternalProcessInstance processInst = this.getProcessInstance(instanceUUID);
        Variable v = VariableUtil.createVariable(processInst.getProcessDefinitionUUID(), variableId, variableValue);
        VariableUpdateImpl varUpdate = new VariableUpdateImpl(new Date(), userId, variableId, v);
        processInst.addVariableUpdate(varUpdate);
    }

    @Override
    public void removeLob(Lob lob) {
        Misc.checkArgsNotNull(lob);
        this.getDbSession().delete(lob);
    }

    @Override
    public void recordActivityPriorityUpdated(ActivityInstanceUUID activityUUID, int priority) {
        Misc.checkArgsNotNull(activityUUID);
        InternalActivityInstance activityInstance = this.getActivityInstance(activityUUID);
        activityInstance.setPriority(priority);
    }

    @Override
    public void storeMetaData(String key, String value) {
        Misc.checkArgsNotNull(key, value);
        MetaDataImpl data = this.getInternalMetaData(key);
        if (data == null) {
            data = new MetaDataImpl(key, value);
            this.getDbSession().save(data);
        } else {
            data.setValue(value);
        }
    }

    private MetaDataImpl getInternalMetaData(String key) {
        Misc.checkArgsNotNull(key);
        return this.getDbSession().getMetaData(key);
    }

    @Override
    public String getMetaData(String key) {
        MetaDataImpl data = this.getInternalMetaData(key);
        if (data == null) {
            return null;
        }
        return data.getValue();
    }

    @Override
    public void deleteMetaData(String key) {
        Misc.checkArgsNotNull(key);
        MetaDataImpl data = this.getInternalMetaData(key);
        if (data != null) {
            this.getDbSession().delete(data);
        }
    }
}

