/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.privilege.impl.RuleImpl;
import org.ow2.bonita.persistence.PrivilegeDbSession;
import org.ow2.bonita.persistence.db.HibernateDbSession;
import org.ow2.bonita.services.Journal;
import org.ow2.bonita.services.PrivilegeService;
import org.ow2.bonita.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbPrivilegeService
extends HibernateDbSession
implements PrivilegeService {
    private static final String PRIVILEGE_DEFAULT_POLICY = "Privilege_default_policy";
    private String persistenceServiceName;

    public DbPrivilegeService(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected PrivilegeDbSession getDbSession() {
        return EnvTool.getPrivilegeDbSession(this.persistenceServiceName);
    }

    @Override
    public void addRule(Rule rule) {
        this.getDbSession().save((RuleImpl)rule);
    }

    @Override
    public Rule getRule(String name) {
        return this.getDbSession().getRule(name);
    }

    @Override
    public Set<Rule> getRules() {
        return this.getDbSession().getRules();
    }

    public void deleteRule(RuleImpl rule) {
        this.getDbSession().delete(rule);
    }

    @Override
    public void deleteRule(Rule rule) {
        this.getDbSession().delete(rule);
    }

    @Override
    public Set<Rule> getRules(Set<String> rulesName) {
        return this.getDbSession().getRules(rulesName);
    }

    @Override
    public PrivilegePolicy getDefaultPolicy() {
        Journal repo = EnvTool.getJournal();
        String defaultPolicy = repo.getMetaData(PRIVILEGE_DEFAULT_POLICY);
        if (defaultPolicy == null) {
            return PrivilegePolicy.ALLOW_BY_DEFAULT;
        }
        try {
            return PrivilegePolicy.valueOf(defaultPolicy);
        }
        catch (Exception e) {
            e.printStackTrace();
            String allowedValues = ", ";
            for (PrivilegePolicy policy : PrivilegePolicy.values()) {
                allowedValues = allowedValues + policy.name();
            }
            allowedValues = allowedValues.substring(1);
            throw new IllegalArgumentException("The value of the privilege global policy is not valid: " + defaultPolicy + ". Only value defined in the PrivilegePolicy.class(" + allowedValues + ") are allowed.");
        }
    }

    @Override
    public Set<Rule> getRulesByType(Rule.RuleType ... ruleTypes) {
        HashSet<String> ruleTypesStr = new HashSet<String>();
        for (Rule.RuleType ruleType : ruleTypes) {
            ruleTypesStr.add(ruleType.name());
        }
        return this.getDbSession().getRulesByType(ruleTypesStr);
    }

    @Override
    public Set<Rule> getAllApplicableRules(String entityID) {
        return this.getDbSession().getAllApplicableRules(entityID);
    }

    @Override
    public Set<Rule> getApplicableRules(String entityID, Rule.RuleType ruleType) {
        return this.getDbSession().getAllApplicableRules(entityID, ruleType);
    }

    @Override
    public void setDefaultPolicy(PrivilegePolicy newPolicy) {
        Journal repo = EnvTool.getJournal();
        String defaultPolicy = repo.getMetaData(PRIVILEGE_DEFAULT_POLICY);
        if (newPolicy == null) {
            if (defaultPolicy != null) {
                repo.deleteMetaData(PRIVILEGE_DEFAULT_POLICY);
            }
        } else {
            repo.storeMetaData(PRIVILEGE_DEFAULT_POLICY, newPolicy.name());
        }
    }

    @Override
    public List<Rule> getRules(Rule.RuleType ruleType, int fromIndex, int pageSige) {
        return this.getDbSession().getRules(ruleType, fromIndex, pageSige);
    }

    @Override
    public Set<String> getExceptions(String entityID, Rule.RuleType ruleType) {
        return this.getDbSession().getAllExceptions(entityID, ruleType);
    }

    @Override
    public long getNumberOfRules(Rule.RuleType ruleType) {
        return this.getDbSession().getNumberOfRules(ruleType);
    }
}

