/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.Transaction;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.persistence.EventDbSession;
import org.ow2.bonita.runtime.event.EventAddedNotification;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbThreadEventService
implements EventService {
    private String persistenceServiceName;
    private static final Logger LOG = Logger.getLogger(DbThreadEventService.class.getName());

    protected DbThreadEventService() {
    }

    public DbThreadEventService(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected EventDbSession getDbSession() {
        return EnvTool.getEventServiceDbSession(this.persistenceServiceName);
    }

    private void refresh() {
        Environment.getCurrent().get(Transaction.class).registerSynchronization(new EventAddedNotification(EnvTool.getEventExecutor()));
    }

    @Override
    public void enableEventsInFailureIncomingEvents(ActivityInstanceUUID activityUUID) {
        Set<IncomingEventInstance> events = this.getDbSession().getActivityIncomingEvents(activityUUID);
        for (IncomingEventInstance event : events) {
            if (event.getRetries() != 0) continue;
            event.setRetries(IncomingEventInstance.DEFAULT_RETRIES);
        }
        this.refresh();
    }

    @Override
    public void enablePermanentEventsInFailure(ActivityDefinitionUUID activityUUID) {
        Set<IncomingEventInstance> events = this.getDbSession().getPermanentIncomingEvents(activityUUID);
        for (IncomingEventInstance event : events) {
            if (event.getRetries() != 0) continue;
            event.setRetries(IncomingEventInstance.DEFAULT_RETRIES);
        }
        this.refresh();
    }

    @Override
    public void fire(OutgoingEventInstance outgoingEventInstance) {
        this.getDbSession().save(outgoingEventInstance);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Firing event outgoing event: " + outgoingEventInstance + "...");
        }
        this.refresh();
    }

    @Override
    public void subscribe(IncomingEventInstance incomingEventInstance) {
        this.getDbSession().save(incomingEventInstance);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Firing event incoming event: " + incomingEventInstance + "...");
        }
        this.refresh();
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents() {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents();
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents() {
        Set<OutgoingEventInstance> outgoings = this.getDbSession().getOutgoingEvents();
        if (outgoings == null) {
            return Collections.emptySet();
        }
        return outgoings;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID actiivtyUUID) {
        Set<OutgoingEventInstance> outgoings = this.getDbSession().getOutgoingEvents(eventName, toProcessName, toActivityName, actiivtyUUID);
        if (outgoings == null) {
            return Collections.emptySet();
        }
        return outgoings;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID actiivtyUUID) {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents(eventName, toProcessName, toActivityName, actiivtyUUID);
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents(ProcessInstanceUUID instanceUUID) {
        Set<OutgoingEventInstance> outgoings = this.getDbSession().getOutgoingEvents(instanceUUID);
        if (outgoings == null) {
            return Collections.emptySet();
        }
        return outgoings;
    }

    public Set<IncomingEventInstance> getIncomingEvents(ProcessInstanceUUID instanceUUID) {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents(instanceUUID);
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public IncomingEventInstance getIncomingEvent(ProcessInstanceUUID instanceUUID, String name) {
        return this.getDbSession().getIncomingEvent(instanceUUID, name);
    }

    public Set<IncomingEventInstance> getIncomingEvents(ActivityDefinitionUUID activityUUID) {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents(activityUUID);
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public Set<EventCouple> getEventsCouples() {
        return this.getDbSession().getEventsCouples();
    }

    @Override
    public IncomingEventInstance getIncomingEvent(long incomingId) {
        return this.getDbSession().getIncomingEvent(incomingId);
    }

    @Override
    public OutgoingEventInstance getOutgoingEvent(long outgoingId) {
        return this.getDbSession().getOutgoingEvent(outgoingId);
    }

    public void removeFiredEvent(OutgoingEventInstance outgoing) {
        this.getDbSession().delete(outgoing);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removing outgoing event: " + outgoing + "...");
        }
    }

    @Override
    public Set<OutgoingEventInstance> getOverdueEvents() {
        return this.getDbSession().getOverdueEvents();
    }

    @Override
    public Set<EventInstance> getConsumedEvents() {
        return this.getDbSession().getConsumedEvents();
    }

    public void removeSubscription(IncomingEventInstance incoming) {
        this.getDbSession().delete(incoming);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removing incoming event: " + incoming + "...");
        }
    }

    @Override
    public void removeSubscriptions(ProcessInstanceUUID instanceUUID) {
        Set<IncomingEventInstance> events = this.getIncomingEvents(instanceUUID);
        if (events != null && !events.isEmpty()) {
            for (IncomingEventInstance event : events) {
                this.removeSubscription(event);
            }
        }
    }

    @Override
    public void removeSubscriptions(ActivityDefinitionUUID activityUUID) {
        Set<IncomingEventInstance> events = this.getIncomingEvents(activityUUID);
        if (events != null && !events.isEmpty()) {
            for (IncomingEventInstance event : events) {
                this.removeSubscription(event);
            }
        }
    }

    @Override
    public void removeFiredEvents(ProcessInstanceUUID instanceUUID) {
        Set<OutgoingEventInstance> events = this.getOutgoingEvents(instanceUUID);
        if (events != null && !events.isEmpty()) {
            for (OutgoingEventInstance event : events) {
                this.removeFiredEvent(event);
            }
        }
    }

    @Override
    public void removeEvent(EventInstance event) {
        this.getDbSession().delete(event);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removing event: " + event + "...");
        }
    }

    @Override
    public Long getNextDueDate() {
        return this.getDbSession().getNextDueDate();
    }
}

