/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.services.Archiver;

public class LoggerArchiver
implements Archiver {
    public static final Logger LOG = Logger.getLogger(LoggerArchiver.class.getName());
    private final Level level;

    public LoggerArchiver() {
        this(Level.FINE);
    }

    public LoggerArchiver(String levelName) {
        this(Level.parse(levelName));
    }

    public LoggerArchiver(Level level) {
        this.level = level;
    }

    public void archive(InternalProcessInstance processInst) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Archiving: " + processInst);
        }
    }

    public void archive(InternalProcessDefinition processDef) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Archiving: " + processDef);
        }
    }

    public void remove(InternalProcessDefinition processDef) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Removing: " + processDef);
        }
    }

    public void remove(InternalProcessInstance processInst) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Removing: " + processInst);
        }
    }

    public void clear() {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Clearing archiver");
        }
    }
}

