/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.TaskInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuerierUtil {
    private QuerierUtil() {
    }

    public static Set<TaskInstance> getUserTasks(Set<ActivityInstance> activities, String userId, ActivityState taskState) {
        HashSet<ActivityState> taskStates = new HashSet<ActivityState>();
        taskStates.add(taskState);
        return QuerierUtil.getUserTasks(activities, userId, taskStates);
    }

    public static Set<TaskInstance> getUserTasks(Set<ActivityInstance> activities, String userId, Collection<ActivityState> taskStates) {
        HashSet<TaskInstance> result = new HashSet<TaskInstance>();
        if (activities != null) {
            for (ActivityInstance activity : activities) {
                if (!activity.isTask() || !taskStates.contains((Object)activity.getTask().getState())) continue;
                TaskInstance taskInstance = activity.getTask();
                String taskUserId = null;
                boolean userIdOk = false;
                boolean candidatesOk = false;
                try {
                    taskUserId = taskInstance.getTaskUser();
                    userIdOk = taskUserId != null && taskUserId.equals(userId);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                if (!userIdOk) {
                    try {
                        Set<String> taskCandidates = taskInstance.getTaskCandidates();
                        candidatesOk = taskCandidates != null && taskCandidates.contains(userId);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
                if (!userIdOk && (taskUserId != null || !candidatesOk)) continue;
                result.add(taskInstance);
            }
        }
        return result;
    }
}

