/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.StaleStateException;
import org.ow2.bonita.services.impl.Interceptor;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryInterceptor
extends Interceptor {
    static final Logger LOG = Logger.getLogger(RetryInterceptor.class.getName());
    int retries = 3;
    long delay = 50L;
    long delayFactor = 4L;

    @Override
    public <T> T execute(Command<T> command) {
        int attempt = 1;
        long sleepTime = this.delay;
        while (attempt <= this.retries) {
            if (attempt > 1 && LOG.isLoggable(Level.INFO)) {
                LOG.info("retrying...");
            }
            try {
                return this.next.execute(command);
            }
            catch (StaleStateException e) {
                block8: {
                    ++attempt;
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("optimistic locking failed: " + (Object)((Object)e));
                        LOG.info("waiting " + sleepTime + " millis");
                    }
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e1) {
                        if (!LOG.isLoggable(Level.FINE)) break block8;
                        LOG.fine("retry sleeping got interrupted");
                    }
                }
                sleepTime *= this.delayFactor;
            }
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("gave up after " + attempt + " attempts");
        }
        String message = ExceptionManager.getInstance().getFullMessage("bp_RI_1", attempt);
        throw new BonitaRuntimeException(message);
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelayFactor() {
        return this.delayFactor;
    }

    public void setDelayFactor(long delayFactor) {
        this.delayFactor = delayFactor;
    }
}

