/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.type;

import java.io.Serializable;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.type.Converter;
import org.ow2.bonita.type.Type;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public abstract class Variable
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long dbid = -1L;
    protected int dbversion = 0;
    protected String key = null;
    protected Converter converter = null;
    protected ProcessDefinitionUUID processUUID;

    public abstract boolean isStorable(Object var1);

    protected abstract Object getObject();

    protected abstract void setObject(Object var1);

    public void setProcessUUID(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supports(Object value) {
        ClassLoader classLoaderToUse = this.getClassLoader();
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoaderToUse != ori) {
                Thread.currentThread().setContextClassLoader(classLoaderToUse);
            }
            if (this.converter != null) {
                boolean bl = this.converter.supports(value);
                return bl;
            }
            boolean bl = this.isStorable(value);
            return bl;
        }
        finally {
            if (ori != null && classLoaderToUse != ori) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object value) {
        ClassLoader classLoaderToUse = this.getClassLoader();
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoaderToUse != ori) {
                Thread.currentThread().setContextClassLoader(classLoaderToUse);
            }
            if (this.converter != null) {
                if (!this.converter.supports(value)) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_V_1", this.converter.getClass().getName(), this.getClass().getName(), value.getClass().getName());
                    throw new BonitaRuntimeException(message);
                }
                value = this.converter.convert(value);
            }
            if (value != null && !this.isStorable(value)) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_V_2", this.getClass().getName(), value.getClass().getName());
                throw new BonitaRuntimeException(message);
            }
            this.setObject(value);
        }
        finally {
            if (ori != null && classLoaderToUse != ori) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        ClassLoader classLoaderToUse = this.getClassLoader();
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            Object value;
            if (classLoaderToUse != ori) {
                Thread.currentThread().setContextClassLoader(classLoaderToUse);
            }
            if ((value = this.getObject()) != null && this.converter != null) {
                value = this.converter.revert(value);
            }
            Object object = value;
            return object;
        }
        finally {
            if (ori != null && classLoaderToUse != ori) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    public String toString() {
        return "${" + this.key + "}";
    }

    public Type getType() {
        Type type = new Type();
        type.setConverter(this.converter);
        type.setVariableClass(this.getClass());
        return type;
    }

    public String getKey() {
        return this.key;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ProcessDefinitionUUID getProcessUUID() {
        return this.processUUID;
    }
}

