/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.type.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ow2.bonita.type.Converter;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public class DateToStringConverter
implements Converter {
    private static final long serialVersionUID = 1L;
    private static String format = "yyyy-MM-dd HH:mm:ss,SSS";
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(format);
        }
    };

    public Object convert(Object o) {
        return dateFormat.get().format((Date)o);
    }

    public Object revert(Object o) {
        try {
            return dateFormat.get().parseObject((String)o);
        }
        catch (ParseException e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_DTSC_1", o);
            throw new BonitaRuntimeException(message, e);
        }
    }

    public boolean supports(Object value) {
        return value != null && value instanceof Date;
    }
}

