/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.type.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.ow2.bonita.type.Converter;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public class SerializableToBytesConverter
implements Converter {
    private static final long serialVersionUID = 1L;

    public boolean supports(Object value) {
        if (value == null) {
            return true;
        }
        return Serializable.class.isAssignableFrom(value.getClass());
    }

    public Object convert(Object o) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_STBC_1", o);
            throw new BonitaRuntimeException(message, e);
        }
        return bytes;
    }

    public Object revert(Object o) {
        byte[] bytes = (byte[])o;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String className = desc.getName();
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(className, true, classLoader);
                    return clazz;
                }
            };
            return ois.readObject();
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_STBC_2", new Object[0]);
            throw new BonitaRuntimeException(message, e);
        }
    }
}

