/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.type.lob;

import java.sql.Blob;
import java.sql.SQLException;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.type.lob.BlobImpl;
import org.ow2.bonita.type.lob.BlobStrategy;
import org.ow2.bonita.type.lob.Lob;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;

public class BlobStrategyBlob
implements BlobStrategy {
    public void set(byte[] bytes, Lob lob) {
        if (bytes != null) {
            lob.cachedBytes = bytes;
            Environment environment = Environment.getCurrent();
            lob.blob = environment != null ? EnvTool.getLobCreator().createBlob(bytes) : new BlobImpl(bytes);
        }
    }

    public byte[] get(Lob lob) {
        if (lob.cachedBytes != null) {
            return lob.cachedBytes;
        }
        Blob sqlBlob = lob.blob;
        if (sqlBlob != null) {
            try {
                return sqlBlob.getBytes(1L, (int)sqlBlob.length());
            }
            catch (SQLException e) {
                throw new BonitaRuntimeException("couldn't extract bytes out of blob", e);
            }
        }
        return null;
    }
}

