/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.type.lob;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.type.lob.BlobStrategy;
import org.ow2.bonita.type.lob.BlobStrategyBlob;
import org.ow2.bonita.type.lob.BytesChop;
import org.ow2.bonita.type.lob.CharChop;
import org.ow2.bonita.type.lob.ClobStrategy;
import org.ow2.bonita.type.lob.ClobStrategyChopped;
import org.ow2.bonita.util.EnvTool;

public class Lob
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BlobStrategy DEFAULT_BLOB_STRATEGY = new BlobStrategyBlob();
    public static final ClobStrategy DEFAULT_CLOB_STRATEGY = new ClobStrategyChopped();
    protected long dbid;
    protected int dbversion;
    protected byte[] cachedBytes = null;
    protected Blob blob = null;
    protected byte[] bytes = null;
    protected List<BytesChop> bytesChops = null;
    protected char[] cachedChars = null;
    protected Clob clob = null;
    protected String text = null;
    protected List<CharChop> charChops = null;

    public Lob() {
    }

    public Lob(byte[] bytes) {
        this.cachedBytes = bytes;
        this.getBlobStrategy().set(bytes, this);
    }

    public Lob(char[] text) {
        this.cachedChars = text;
        this.getClobStrategy().set(text, this);
    }

    public char[] extractChars() {
        return this.getClobStrategy().get(this);
    }

    public byte[] extractBytes() {
        return this.getBlobStrategy().get(this);
    }

    protected ClobStrategy getClobStrategy() {
        if (Environment.getCurrent() == null) {
            return DEFAULT_CLOB_STRATEGY;
        }
        return EnvTool.getClobStrategy();
    }

    protected BlobStrategy getBlobStrategy() {
        if (Environment.getCurrent() == null) {
            return DEFAULT_BLOB_STRATEGY;
        }
        return EnvTool.getBlobStrategy();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.cachedBytes != null) {
            this.getBlobStrategy().set(this.cachedBytes, this);
        }
        if (this.cachedChars != null) {
            this.getClobStrategy().set(this.cachedChars, this);
        }
        return this;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.blob = null;
        this.clob = null;
        return this;
    }
}

