/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.type.matcher;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.type.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateIdMatcher
implements Matcher {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(HibernateIdMatcher.class.getName());
    String hibernateSessionFactoryName;

    public HibernateIdMatcher(String hibernateSessionFactoryName) {
        this.hibernateSessionFactoryName = hibernateSessionFactoryName;
    }

    protected abstract Class<? extends Type> getIdType();

    @Override
    public boolean matches(String name, Object value) {
        boolean matches = false;
        Environment environment = Environment.getCurrent();
        if (environment != null) {
            SessionFactory sessionFactory = null;
            sessionFactory = this.hibernateSessionFactoryName != null ? (SessionFactory)environment.get(this.hibernateSessionFactoryName) : environment.get(SessionFactory.class);
            if (sessionFactory != null) {
                ClassMetadata classMetadata = sessionFactory.getClassMetadata(value.getClass());
                matches = classMetadata != null && classMetadata.getIdentifierType().getClass() == this.getIdType();
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("no current environment so valueClass cannot be stored as an id-ref to a hibernate object");
            }
            matches = false;
        }
        return matches;
    }

    public String getHibernateSessionFactoryName() {
        return this.hibernateSessionFactoryName;
    }

    public void setHibernateSessionFactoryName(String hibernateSessionFactoryName) {
        this.hibernateSessionFactoryName = hibernateSessionFactoryName;
    }
}

