/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.element.impl.BusinessArchiveImpl;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BusinessArchiveFactory {
    private BusinessArchiveFactory() {
    }

    public static void generateBusinessArchiveFile(File barFile, ProcessDefinition process, Map<String, byte[]> resources, Class<?> ... classes) throws IOException, ClassNotFoundException {
        Misc.checkArgsNotNull(barFile);
        byte[] barContent = BusinessArchiveFactory.getBusinessArchiveContent(process, resources, classes);
        BusinessArchiveFactory.generateBusinessArchiveFile(barFile, barContent);
    }

    public static void generateBusinessArchiveFile(File barFile, BusinessArchive businessArchive) throws IOException {
        Misc.checkArgsNotNull(barFile, businessArchive);
        byte[] barContent = Misc.generateJar(businessArchive.getResources());
        BusinessArchiveFactory.generateBusinessArchiveFile(barFile, barContent);
    }

    private static void generateBusinessArchiveFile(File barFile, byte[] barContent) throws IOException {
        Misc.checkArgsNotNull(barFile, barContent);
        Misc.write(barFile, barContent);
    }

    public static BusinessArchive getBusinessArchive(URL businessArchiveFileUrl) throws URISyntaxException, IOException, ClassNotFoundException {
        return BusinessArchiveFactory.getBusinessArchive(new File(businessArchiveFileUrl.toURI()));
    }

    public static BusinessArchive getBusinessArchive(Map<String, byte[]> resources) throws IOException, ClassNotFoundException {
        return BusinessArchiveFactory.getBusinessArchive(resources, true);
    }

    public static BusinessArchive getBusinessArchive(Map<String, byte[]> resources, boolean deserializeProcess) throws IOException, ClassNotFoundException {
        HashMap<String, byte[]> newResources = new HashMap<String, byte[]>();
        ProcessDefinition process = null;
        for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
            if (resource.getKey().endsWith(".xpdl")) {
                if (!deserializeProcess) continue;
                File xpdlFile = File.createTempFile("xpdl", null);
                Misc.getFile(xpdlFile, resource.getValue());
                process = ProcessBuilder.createProcessFromXpdlFile(xpdlFile.toURL());
                xpdlFile.delete();
                continue;
            }
            if (resource.getKey().equals("process-def.xml")) {
                if (!deserializeProcess) continue;
                File xmlDefFile = File.createTempFile("xmlDef", null);
                Misc.getFile(xmlDefFile, resource.getValue());
                process = ProcessBuilder.createProcessFromXmlDefFile(xmlDefFile.toURL());
                xmlDefFile.delete();
                continue;
            }
            newResources.put(resource.getKey(), resource.getValue());
        }
        return new BusinessArchiveImpl(process, newResources, new Class[0]);
    }

    public static BusinessArchive getBusinessArchive(File businessArchiveFile) throws IOException, ClassNotFoundException {
        return BusinessArchiveFactory.getBusinessArchive(businessArchiveFile, true);
    }

    public static BusinessArchive getBusinessArchive(File businessArchiveFile, boolean deserializeProcess) throws IOException, ClassNotFoundException {
        if (!businessArchiveFile.exists()) {
            throw new FileNotFoundException("File " + businessArchiveFile + "doesn't exists.");
        }
        byte[] fileAsBytes = Misc.getAllContentFrom(businessArchiveFile);
        Map<String, byte[]> resources = Misc.getResourcesFromZip(fileAsBytes);
        return BusinessArchiveFactory.getBusinessArchive(resources, deserializeProcess);
    }

    public static BusinessArchive getBusinessArchive(ProcessDefinition process, Class<?> ... classes) throws IOException, ClassNotFoundException {
        Misc.checkArgsNotNull(process);
        return new BusinessArchiveImpl(process, null, classes);
    }

    public static BusinessArchive getBusinessArchive(ProcessDefinition process, Map<String, byte[]> resources, Class<?> ... classes) throws IOException, ClassNotFoundException {
        Misc.checkArgsNotNull(process);
        return new BusinessArchiveImpl(process, resources, classes);
    }

    private static byte[] getBusinessArchiveContent(ProcessDefinition process, Map<String, byte[]> resources, Class<?> ... classes) throws IOException, ClassNotFoundException {
        BusinessArchive businessArchive = BusinessArchiveFactory.getBusinessArchive(process, resources, classes);
        return Misc.generateJar(businessArchive.getResources());
    }
}

