/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.type.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CopyTool {
    public static final String DEPLOYMENT_IDPREFIX = "deployment$";

    protected CopyTool() {
    }

    public static Set<String> copy(Set<String> src) {
        if (src == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(src);
    }

    public static List<String> copy(List<String> src) {
        if (src == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(src);
    }

    public static Map<String, Object> copySer(Map<String, Serializable> src) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (src != null) {
            for (Map.Entry<String, Serializable> entry : src.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static Map<String, String> copy(Map<String, String> src) {
        if (src == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(src);
    }

    public static Map<String, Object[]> copyMap(Map<String, Object[]> src) {
        if (src == null) {
            return new HashMap<String, Object[]>();
        }
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        for (Map.Entry<String, Object[]> entry : src.entrySet()) {
            String key = entry.getKey();
            Object[] value = entry.getValue();
            ArrayList<Object> newValue = null;
            if (value != null) {
                newValue = new ArrayList<Object>();
                for (Object o : value) {
                    newValue.add(o);
                }
            }
            result.put(key, newValue.toArray());
        }
        return result;
    }

    public static Date copy(Date src) {
        if (src == null) {
            return null;
        }
        return (Date)src.clone();
    }

    public static Map<String, Object> getVariableValues(Map<String, Variable> variableMap) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (variableMap != null) {
            for (Variable var : variableMap.values()) {
                res.put(var.getKey(), (Serializable)var.getValue());
            }
        }
        return res;
    }
}

