/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.impl.CaseImpl;
import org.ow2.bonita.facade.runtime.impl.CommentImpl;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.util.DbTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DbMigration {
    private static final Logger LOG = Logger.getLogger(DbMigration.class.getName());

    private DbMigration() {
    }

    public static void migrateDb(String configurationName, String db, String currentVersion, String targetVersion) throws Exception {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(configurationName.replaceAll("-configuration", "-session-factory"));
        LOG.info("Running " + db + " " + configurationName + " DB migration...");
        InputStream inputStream = DbMigration.findMigrationScript(db, currentVersion, targetVersion);
        DbMigration.executeScript((SessionFactory)sessionFactory, inputStream, db);
        DbMigration.executePostMigration((SessionFactory)sessionFactory, targetVersion);
        LOG.info("---------------Schema migrated---------------");
    }

    private static void executePostMigration(SessionFactory sessionFactory, String targetVersion) throws Exception {
        if ("5.2".equals(targetVersion)) {
            Session session = sessionFactory.openSession();
            session.getTransaction().begin();
            Query getInstancesQuery = session.createQuery("SELECT instance FROM org.ow2.bonita.facade.runtime.impl.InternalProcessInstance AS instance");
            List processInstances = getInstancesQuery.list();
            for (Object processInstance : processInstances) {
                InternalProcessInstance instance = (InternalProcessInstance)processInstance;
                List<Comment> comments = instance.getCommentFeed();
                if (comments == null || comments.isEmpty()) continue;
                for (Comment comment : comments) {
                    CommentImpl impl = (CommentImpl)comment;
                    impl.setInstanceUUID(instance.getUUID());
                }
            }
            Query getUsersQuery = session.createQuery("SELECT DISTINCT user FROM org.ow2.bonita.facade.identity.impl.UserImpl AS user");
            List users = getUsersQuery.list();
            for (Object user : users) {
                UserImpl myUser = (UserImpl)user;
                myUser.setUUID(Long.toString(myUser.getId()));
            }
            Query getRolesQuery = session.createQuery("SELECT DISTINCT role FROM org.ow2.bonita.facade.identity.impl.RoleImpl AS role");
            List roles = getRolesQuery.list();
            for (Comment role : roles) {
                RoleImpl myrole = (RoleImpl)((Object)role);
                myrole.setUUID(Long.toString(myrole.getId()));
            }
            Query getCasesQuery = session.createQuery("SELECT webcase FROM org.ow2.bonita.facade.runtime.impl.CaseImpl AS webcase");
            List cases = getCasesQuery.list();
            for (Object case_ : cases) {
                CaseImpl mycase = (CaseImpl)case_;
                mycase.setLabelName(mycase.getLabelName());
            }
            session.getTransaction().commit();
            session.close();
        }
    }

    public static void executeScript(SessionFactory sessionFactory, InputStream inputStream, String db) {
        byte[] bytes = IoUtil.readBytes(inputStream);
        String scriptContent = new String(bytes);
        List<String> commands = DbMigration.getCommands(scriptContent, db);
        Session session = sessionFactory.openSession();
        session.getTransaction().begin();
        LOG.severe("DB Commands Execution");
        for (String command : commands) {
            LOG.severe("Executing command : " + command);
            try {
                session.createSQLQuery(command).executeUpdate();
            }
            catch (Exception e) {
                System.err.println("Error while executing command: " + command);
                e.printStackTrace();
                LOG.severe(e.getMessage());
            }
        }
        session.getTransaction().commit();
        session.close();
    }

    public static List<String> getCommands(String scriptContent, String db) {
        String commandsSeparator = ";";
        if (db.equals("sqlserver") || db.equals("sybase")) {
            commandsSeparator = "go";
        }
        ArrayList<String> commands = new ArrayList<String>();
        int index = 0;
        while (index < scriptContent.length()) {
            String command;
            int separatorIndex = scriptContent.indexOf(commandsSeparator, index);
            int separatorUpperCaseIndex = scriptContent.indexOf(commandsSeparator.toUpperCase(), index);
            if (separatorUpperCaseIndex != -1 && separatorUpperCaseIndex < separatorIndex) {
                separatorIndex = separatorUpperCaseIndex;
            }
            if (separatorIndex == -1) {
                separatorIndex = scriptContent.length();
            }
            if ((command = scriptContent.substring(index, separatorIndex).trim()).length() > 0) {
                commands.add(command);
            }
            index = separatorIndex + commandsSeparator.length();
        }
        return commands;
    }

    public static InputStream findMigrationScript(String db, String currentVersion, String targetVersion) {
        StringBuilder migrationScript = new StringBuilder();
        migrationScript.append("/migration/").append(db).append("-").append(currentVersion).append("-").append(targetVersion).append(".sql");
        LOG.info("Loading Script " + migrationScript.toString());
        InputStream inputStream = DbMigration.class.getResourceAsStream(migrationScript.toString());
        if (inputStream == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_2", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        return inputStream;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 3) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_1", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        String db = args[0].toLowerCase();
        String currentVersion = args[1];
        String targetVersion = args[2];
        LOG.info("Starting History DB migration");
        DbMigration.migrateDb("hibernate-configuration:history", db, currentVersion, targetVersion);
        LOG.info("Starting Core DB migration");
        DbMigration.migrateDb("hibernate-configuration:core", db, currentVersion, targetVersion);
    }
}

