/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cache.Cache;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.GlobalEnvironmentFactory;
import org.ow2.bonita.facade.def.element.impl.MetaDataImpl;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.type.lob.Lob;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DbTool {
    static final Logger LOG = Logger.getLogger(DbTool.class.getName());

    private DbTool() {
    }

    public static Configuration getConfiguration(String configurationName) {
        EnvironmentFactory envFactory = GlobalEnvironmentFactory.getEnvironmentFactory();
        if (envFactory == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBT_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        Configuration config = (Configuration)envFactory.get(configurationName);
        if (config == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBT_2", configurationName);
            throw new BonitaRuntimeException(message);
        }
        return config;
    }

    private static SchemaExport getSchemaExport(Configuration config) {
        return new SchemaExport(config, config.buildSettings());
    }

    public static void recreateDb(String configurationName) {
        SessionFactoryImplementor sessionFactory;
        Configuration config = DbTool.getConfiguration(configurationName);
        if (LOG.isLoggable(Level.FINE) && (sessionFactory = DbTool.getSessionFactory(configurationName.replaceAll("-configuration", "-session-factory"))) != null) {
            String[] script;
            Dialect dialect = sessionFactory.getDialect();
            for (String s : script = config.generateSchemaCreationScript(dialect)) {
                LOG.fine(s);
            }
        }
        if (DbTool.isOnDb("mysql", config)) {
            LOG.severe("Running on MySQL DB, updating schema...");
            PersistentClass pc = config.getClassMapping(Lob.class.getName());
            Table table = pc.getTable();
            Iterator columns = table.getColumnIterator();
            while (columns.hasNext()) {
                Column column = (Column)columns.next();
                String columnName = "BLOB_VALUE_";
                if (!column.getName().equals("BLOB_VALUE_")) continue;
                LOG.severe("Updating BLOB_VALUE_ column...");
                column.setSqlType("LONGBLOB");
                column.setLength(518576);
            }
        }
        SchemaExport schemaExport = DbTool.getSchemaExport(config);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating schema...");
        }
        schemaExport.create(false, true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Schema created.");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Adding default users...");
        }
        DbTool.addDefaultUsers(configurationName);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Default users added.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultUsers(String configurationName) {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(configurationName.replaceAll("-configuration", "-session-factory"));
        if (sessionFactory != null) {
            Session session = null;
            try {
                session = sessionFactory.openSession();
                Transaction tx = session.beginTransaction();
                RoleImpl userRole = DbTool.createDefaultRole("user", "User", "The user Role");
                RoleImpl adminRole = DbTool.createDefaultRole("admin", "Admin", "The admin Role");
                HashSet<RoleImpl> userRoles = new HashSet<RoleImpl>();
                userRoles.add(userRole);
                HashSet<RoleImpl> adminRoles = new HashSet<RoleImpl>();
                adminRoles.add(adminRole);
                DbTool.addDefaultUser((org.hibernate.Session)session, "admin", "", "", "bpm", adminRoles);
                DbTool.addDefaultUser((org.hibernate.Session)session, "john", "John", "Doe", "bpm", userRoles);
                DbTool.addDefaultUser((org.hibernate.Session)session, "jack", "Jack", "Doe", "bpm", userRoles);
                DbTool.addDefaultUser((org.hibernate.Session)session, "james", "James", "Doe", "bpm", userRoles);
                MetaDataImpl defaultUsersAddedMetadata = new MetaDataImpl("DEFAULT_USERS_CREATED", "true");
                session.save((Object)defaultUsersAddedMetadata);
                tx.commit();
            }
            catch (HibernateException e) {
                LOG.log(Level.WARNING, "Unable to add the default users in the DB", e);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    private static RoleImpl createDefaultRole(String name, String label, String description) throws HibernateException {
        RoleImpl userRole = new RoleImpl(name);
        userRole.setLabel(label);
        userRole.setDescription(description);
        return userRole;
    }

    private static void addDefaultUser(org.hibernate.Session session, String username, String firstName, String lastName, String password, Set<RoleImpl> roles) throws HibernateException {
        UserImpl user = new UserImpl(username, password);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        for (RoleImpl role : roles) {
            user.addRole(role);
        }
        session.save((Object)user);
    }

    public static SessionFactoryImplementor getSessionFactory(String sessionFactoryName) {
        SessionFactory sessionFactory = (SessionFactory)GlobalEnvironmentFactory.getEnvironmentFactory().get(sessionFactoryName);
        if (sessionFactory != null && sessionFactory instanceof SessionFactoryImplementor) {
            return (SessionFactoryImplementor)sessionFactory;
        }
        return null;
    }

    public static void dropDb(String configurationName) {
        SchemaExport schemaExport = DbTool.getSchemaExport(DbTool.getConfiguration(configurationName));
        schemaExport.drop(false, true);
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBT_3", "hibernate-configuration:core", "hibernate-configuration:history");
            throw new IllegalArgumentException(message);
        }
        for (String conf : args) {
            DbTool.recreateDb(conf);
        }
    }

    public static boolean isOnDb(String dbName, Configuration config) {
        String lowerDbName = dbName.toLowerCase();
        String dialect = DbTool.getDbDialect(config).toLowerCase();
        String url = DbTool.getDbUrl(config).split(":")[1].toLowerCase();
        return dialect.contains(lowerDbName) || url.contains(lowerDbName);
    }

    public static String getDbDialect(Configuration config) {
        return config.getProperty("hibernate.dialect");
    }

    public static String getDbUrl(Configuration config) {
        return config.getProperty("hibernate.connection.url");
    }

    public static String getDbUseQueryCache(Configuration config) {
        return config.getProperty("hibernate.cache.use_query_cache");
    }

    public static String getDbUseSecondLeveleCache(Configuration config) {
        return config.getProperty("hibernate.cache.use_second_level_cache");
    }

    public static String getDbDriverClass(Configuration config) {
        return config.getProperty("hibernate.connection.driver_class");
    }

    public static void cleanCache(String sessionFactoryName) {
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(sessionFactoryName);
        if (sessionFactory != null) {
            sessionFactory.evictQueries();
            Map caches = sessionFactory.getAllSecondLevelCacheRegions();
            for (Cache cache : caches.values()) {
                cache.clear();
            }
        }
    }
}

