/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.Writer;
import java.util.Stack;
import java.util.Vector;
import org.ow2.bonita.util.ExceptionManager;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class DebugDomBuilder
extends DefaultHandler
implements ContentHandler,
LexicalHandler {
    public Document document;
    protected String debugNamespace = null;
    protected String lineAttributeName = "line";
    protected String columnAttributeName = null;
    protected Node currentNode = null;
    protected Node root = null;
    protected Node nextSibling = null;
    public DocumentFragment docFrag = null;
    protected Stack elemStack = new Stack();
    protected Vector prefixMappings = new Vector();
    protected Locator locator = null;
    protected boolean inCData = false;

    DebugDomBuilder() {
    }

    public Node getRootDocument() {
        return null != this.docFrag ? this.docFrag : this.document;
    }

    public Node getRootNode() {
        return this.root;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setNextSibling(Node nextSibling) {
        this.nextSibling = nextSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public Writer getWriter() {
        return null;
    }

    protected void append(Node newNode) throws SAXException {
        Node currentNode = this.currentNode;
        if (null != currentNode) {
            if (currentNode == this.root && this.nextSibling != null) {
                currentNode.insertBefore(newNode, this.nextSibling);
            } else {
                currentNode.appendChild(newNode);
            }
        } else if (null != this.docFrag) {
            if (this.nextSibling != null) {
                this.docFrag.insertBefore(newNode, this.nextSibling);
            } else {
                this.docFrag.appendChild(newNode);
            }
        } else {
            boolean ok = true;
            short type = newNode.getNodeType();
            if (type == 3) {
                String data = newNode.getNodeValue();
                if (null != data && data.trim().length() > 0) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_DDB_1", new Object[0]);
                    throw new SAXException(message);
                }
                ok = false;
            } else if (type == 1 && this.document.getDocumentElement() != null) {
                ok = false;
                String message = ExceptionManager.getInstance().getFullMessage("bp_DDB_2", new Object[0]);
                throw new SAXException(message);
            }
            if (ok) {
                if (this.nextSibling != null) {
                    this.document.insertBefore(newNode, this.nextSibling);
                } else {
                    this.document.appendChild(newNode);
                }
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        Element elem = null == ns || ns.length() == 0 ? this.document.createElementNS(null, name) : this.document.createElementNS(ns, name);
        this.append(elem);
        try {
            int nAtts = atts.getLength();
            if (0 != nAtts) {
                for (int i = 0; i < nAtts; ++i) {
                    String attrQName;
                    String attrNS;
                    if (atts.getType(i).equalsIgnoreCase("ID")) {
                        this.setIDAttribute(atts.getValue(i), elem);
                    }
                    if ("".equals(attrNS = atts.getURI(i))) {
                        attrNS = null;
                    }
                    if ((attrQName = atts.getQName(i)).startsWith("xmlns:") || attrQName.equals("xmlns")) {
                        attrNS = "http://www.w3.org/2000/xmlns/";
                    }
                    elem.setAttributeNS(attrNS, attrQName, atts.getValue(i));
                }
            }
            if (this.locator != null) {
                int lineNumber = this.locator.getLineNumber();
                int columnNumber = this.locator.getColumnNumber();
                if (this.debugNamespace == null) {
                    if (this.lineAttributeName != null) {
                        elem.setAttribute(this.lineAttributeName, Integer.toString(lineNumber));
                    }
                    if (this.columnAttributeName != null) {
                        elem.setAttribute(this.columnAttributeName, Integer.toString(columnNumber));
                    }
                } else {
                    if (this.lineAttributeName != null) {
                        elem.setAttributeNS(this.debugNamespace, this.lineAttributeName, Integer.toString(lineNumber));
                    }
                    if (this.columnAttributeName != null) {
                        elem.setAttributeNS(this.debugNamespace, this.columnAttributeName, Integer.toString(columnNumber));
                    }
                }
            }
            int nDecls = this.prefixMappings.size();
            for (int i = 0; i < nDecls; i += 2) {
                String prefix = (String)this.prefixMappings.elementAt(i);
                if (prefix == null) continue;
                String declURL = (String)this.prefixMappings.elementAt(i + 1);
                elem.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix, declURL);
            }
            this.prefixMappings.clear();
            this.elemStack.push(elem);
            this.currentNode = elem;
        }
        catch (Exception de) {
            throw new SAXException(de);
        }
    }

    public void endElement(String ns, String localName, String name) throws SAXException {
        this.elemStack.pop();
        this.currentNode = this.elemStack.isEmpty() ? null : (Node)this.elemStack.peek();
    }

    public void setIDAttribute(String id, Element elem) {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        Node childNode;
        if (this.isOutsideDocElem() && DebugDomBuilder.isWhiteSpace(ch, start, length)) {
            return;
        }
        if (this.inCData) {
            this.cdata(ch, start, length);
            return;
        }
        String s = new String(ch, start, length);
        Node node = childNode = this.currentNode != null ? this.currentNode.getLastChild() : null;
        if (childNode != null && childNode.getNodeType() == 3) {
            ((Text)childNode).appendData(s);
        } else {
            Text text = this.document.createTextNode(s);
            this.append(text);
        }
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        if (this.isOutsideDocElem() && DebugDomBuilder.isWhiteSpace(ch, start, length)) {
            return;
        }
        String s = new String(ch, start, length);
        this.append(this.document.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(this.document.createTextNode(s));
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void entityReference(String name) throws SAXException {
        this.append(this.document.createEntityReference(name));
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.isOutsideDocElem()) {
            return;
        }
        String s = new String(ch, start, length);
        this.append(this.document.createTextNode(s));
    }

    private boolean isOutsideDocElem() {
        return null == this.docFrag && this.elemStack.size() == 0 && (null == this.currentNode || this.currentNode.getNodeType() == 9);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.append(this.document.createProcessingInstruction(target, data));
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.append(this.document.createComment(new String(ch, start, length)));
    }

    public void startCDATA() throws SAXException {
        this.inCData = true;
        this.append(this.document.createCDATASection(""));
    }

    public void endCDATA() throws SAXException {
        this.inCData = false;
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        if (this.isOutsideDocElem() && DebugDomBuilder.isWhiteSpace(ch, start, length)) {
            return;
        }
        String s = new String(ch, start, length);
        CDATASection section = (CDATASection)this.currentNode.getLastChild();
        section.appendData(s);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        prefix = null == prefix || prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
        this.prefixMappings.addElement(prefix);
        this.prefixMappings.addElement(uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public static boolean isWhiteSpace(char[] ch, int start, int length) {
        int end = start + length;
        for (int s = start; s < end; ++s) {
            if (DebugDomBuilder.isWhiteSpace(ch[s])) continue;
            return false;
        }
        return true;
    }

    public void setDebugNamespace(String debugNamespace) {
        this.debugNamespace = debugNamespace;
    }

    public void setLineAttributeName(String lineAttributeName) {
        this.lineAttributeName = lineAttributeName;
    }

    public void setColumnAttributeName(String columnAttributeName) {
        this.columnAttributeName = columnAttributeName;
    }

    public String getDebugNamespace() {
        return this.debugNamespace;
    }

    public String getLineAttributeName() {
        return this.lineAttributeName;
    }

    public String getColumnAttributeName() {
        return this.columnAttributeName;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }
}

