/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.BonitaSecurityContext;
import org.ow2.bonita.persistence.ApplicationAccessDbSession;
import org.ow2.bonita.persistence.EventDbSession;
import org.ow2.bonita.persistence.IdentityDbSession;
import org.ow2.bonita.persistence.JournalDbSession;
import org.ow2.bonita.persistence.PrivilegeDbSession;
import org.ow2.bonita.persistence.QuerierDbSession;
import org.ow2.bonita.persistence.WebDbSession;
import org.ow2.bonita.persistence.WebTokenManagementDbSession;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.services.Archiver;
import org.ow2.bonita.services.AuthenticationService;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.IdentityService;
import org.ow2.bonita.services.Journal;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.LobCreator;
import org.ow2.bonita.services.PrivilegeService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.services.UUIDService;
import org.ow2.bonita.services.WebService;
import org.ow2.bonita.services.WebTokenManagementService;
import org.ow2.bonita.services.handlers.FinishedInstanceHandler;
import org.ow2.bonita.services.impl.QuerierListAccessor;
import org.ow2.bonita.type.VariableTypeResolver;
import org.ow2.bonita.type.lob.BlobStrategy;
import org.ow2.bonita.type.lob.ClobStrategy;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnvTool {
    private EnvTool() {
    }

    public static JournalDbSession getJournalDbSession(String id) {
        return EnvTool.getEnvObject(JournalDbSession.class, id);
    }

    public static QuerierDbSession getQuerierDbSession(String id) {
        return EnvTool.getEnvObject(QuerierDbSession.class, id);
    }

    public static WebDbSession getWebServiceDbSession(String id) {
        return EnvTool.getEnvObject(WebDbSession.class, id);
    }

    public static IdentityDbSession getIdentityDbSession(String id) {
        return EnvTool.getEnvObject(IdentityDbSession.class, id);
    }

    public static ApplicationAccessDbSession getApplicationAccessDbSession(String id) {
        return EnvTool.getEnvObject(ApplicationAccessDbSession.class, id);
    }

    public static EventDbSession getEventServiceDbSession(String id) {
        return EnvTool.getEnvObject(EventDbSession.class, id);
    }

    public static PrivilegeDbSession getPrivilegeDbSession(String id) {
        return EnvTool.getEnvObject(PrivilegeDbSession.class, id);
    }

    public static WebTokenManagementDbSession getWebTokenManagementDbSession(String id) {
        return EnvTool.getEnvObject(WebTokenManagementDbSession.class, id);
    }

    public static <T> T get(Class<T> class1, String key) {
        Misc.checkArgsNotNull(class1, key);
        Object o = EnvTool.getEnv().get(key);
        String message = ExceptionManager.getInstance().getFullMessage("bis_ET_1", key);
        Misc.badStateIfNull(o, message);
        message = ExceptionManager.getInstance().getFullMessage("bis_ET_2", class1, o.getClass());
        Misc.badStateIfFalse(class1.isAssignableFrom(o.getClass()), message);
        return (T)o;
    }

    protected static Environment getEnv() {
        Environment environment = Environment.getCurrent();
        Misc.badStateIfNull(environment, "Environment is null!");
        return environment;
    }

    protected static <T> T getEnvObject(Class<T> clazz, String name) {
        Environment environment = EnvTool.getEnv();
        Misc.badStateIfNull(environment, "Environment is null!");
        Object object = environment.get(name);
        if (object == null) {
            String message = ExceptionManager.getInstance().getMessage("bs_SET_1", name);
            throw new BonitaRuntimeException(message);
        }
        if (!clazz.isInstance(object)) {
            String message = ExceptionManager.getInstance().getMessage("bs_SET_2", object, name, clazz.getName());
            throw new BonitaRuntimeException(message);
        }
        return (T)object;
    }

    protected static <T> T getEnvClass(Class<T> clazz) {
        Environment environment = EnvTool.getEnv();
        T object = environment.get(clazz);
        if (object == null) {
            String message = ExceptionManager.getInstance().getFullMessage("be_EET_1", clazz.getName());
            throw new BonitaRuntimeException(message);
        }
        return object;
    }

    public static BonitaSecurityContext getBonitaSecurityContext() {
        return EnvTool.getEnvClass(BonitaSecurityContext.class);
    }

    public static Journal getJournal() {
        return EnvTool.getEnvClass(Journal.class);
    }

    public static LargeDataRepository getLargeDataRepository() {
        return EnvTool.getEnvObject(LargeDataRepository.class, "large-data-repository");
    }

    public static IdentityService getIdentityService() {
        return EnvTool.getEnvObject(IdentityService.class, "identity-service");
    }

    public static CommandService getCommandService() {
        return EnvTool.getEnvObject(CommandService.class, "command-service");
    }

    public static AuthenticationService getAuthenticationService() {
        return EnvTool.getEnvObject(AuthenticationService.class, "authentication-service");
    }

    public static WebService getWebService() {
        return EnvTool.getEnvObject(WebService.class, "web-service");
    }

    public static EventService getEventService() {
        return EnvTool.getEnvObject(EventService.class, "event-service");
    }

    public static UUIDService getUUIDService() {
        return EnvTool.getEnvObject(UUIDService.class, "uuid-service");
    }

    public static PrivilegeService getPrivilegeService() {
        return EnvTool.getEnvObject(PrivilegeService.class, "privilege-service");
    }

    public static WebTokenManagementService getWebTokenManagementService() {
        return EnvTool.getEnvObject(WebTokenManagementService.class, "web-token-service");
    }

    public static LobCreator getLobCreator() {
        return EnvTool.getEnvClass(LobCreator.class);
    }

    public static BlobStrategy getBlobStrategy() {
        return EnvTool.getEnvClass(BlobStrategy.class);
    }

    public static ClobStrategy getClobStrategy() {
        return EnvTool.getEnvClass(ClobStrategy.class);
    }

    public static EventExecutor getEventExecutor() {
        return EnvTool.getEnvClass(EventExecutor.class);
    }

    public static Recorder getRecorder() {
        return EnvTool.getEnvObject(Recorder.class, "recorder");
    }

    public static Archiver getArchiver() {
        return EnvTool.getEnvObject(Archiver.class, "archiver");
    }

    public static Querier getAllQueriers() {
        return EnvTool.getQuerierListAccessor("queryList").getAllQueriers();
    }

    public static Querier getJournalQueriers() {
        return EnvTool.getQuerierListAccessor("queryList").getJournals();
    }

    public static Querier getHistoryQueriers() {
        return EnvTool.getQuerierListAccessor("queryList").getHistories();
    }

    private static QuerierListAccessor getQuerierListAccessor(String queryList) {
        return EnvTool.getEnvObject(QuerierListAccessor.class, queryList);
    }

    public static Querier getAllQueriers(String queryList) {
        return EnvTool.getQuerierListAccessor(queryList).getAllQueriers();
    }

    public static Querier getJournalQueriers(String queryList) {
        return EnvTool.getQuerierListAccessor(queryList).getJournals();
    }

    public static Querier getHistoryQueriers(String queryList) {
        return EnvTool.getQuerierListAccessor(queryList).getHistories();
    }

    public static FinishedInstanceHandler getFinishedInstanceHandler() {
        return EnvTool.getEnvObject(FinishedInstanceHandler.class, "finished-instance-handler");
    }

    public static String getUserId() {
        String userId = EnvTool.getEnv().getUserId();
        if (userId == null) {
            String message = ExceptionManager.getInstance().getMessage("bs_SET_3", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        return userId;
    }

    public static VariableTypeResolver getVariableTypeResolver() {
        return EnvTool.getEnvClass(VariableTypeResolver.class);
    }
}

