/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ExceptionManager {
    private static ExceptionManager instance = new ExceptionManager();
    private ResourceBundle bundle;

    private ExceptionManager() {
        Locale currentLocale = Locale.ENGLISH;
        this.bundle = ResourceBundle.getBundle(this.getClass().getName(), currentLocale);
    }

    public static ExceptionManager getInstance() {
        return instance;
    }

    public String getFullMessage(String id, Object ... arguments) {
        StringBuilder message = new StringBuilder();
        if (!this.containsAlreadyAnId(arguments)) {
            message.append(this.getIdMessage(id));
        }
        message.append(this.getMessage(id, arguments));
        return message.toString();
    }

    public String getIdMessage(String id) {
        StringBuilder message = new StringBuilder("Bonita Error: ");
        message.append(id);
        message.append("\n");
        return message.toString();
    }

    public String getMessage(String id, Object ... arguments) {
        StringBuilder message = new StringBuilder();
        String pattern = this.getValue(id);
        if (pattern == null) {
            message.append("Bonita Error: " + id + " does not exist.");
        } else {
            String msg = MessageFormat.format(pattern, arguments);
            message.append(msg);
        }
        message.append("\n");
        return message.toString();
    }

    private String getValue(String id) {
        try {
            return this.bundle.getString(id);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    private boolean containsAlreadyAnId(Object ... arguments) {
        boolean contains = false;
        if (arguments != null) {
            for (Object object : arguments) {
                String temp;
                if (!(object instanceof String) || !(temp = (String)object).contains("Bonita Error")) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }
}

