/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import groovy.lang.Binding;
import groovy.lang.Script;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.impl.StandardQueryAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.ObjectVariable;
import org.ow2.bonita.facade.runtime.impl.ProcessInstanceImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyScriptBuilder;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyUtil {
    public static Object evaluate(String expression, Map<String, Object> variables, ClassLoader classLoader) throws GroovyException {
        return GroovyUtil.evaluate(expression, variables, null, null, null, false, false, classLoader);
    }

    public static Object evaluate(String expression, Map<String, Object> variables) throws GroovyException {
        return GroovyUtil.evaluate(expression, variables, null, null, null, false, false, null);
    }

    public static Object evaluate(String expression, Map<String, Object> context, ActivityInstanceUUID activityUUID, boolean useActivityScope, boolean propagate) throws GroovyException {
        ProcessInstanceUUID processInstanceUUID = null;
        ProcessDefinitionUUID processDefinitionUUID = null;
        processInstanceUUID = activityUUID.getProcessInstanceUUID();
        processDefinitionUUID = processInstanceUUID.getProcessDefinitionUUID();
        return GroovyUtil.evaluate(expression, context, processDefinitionUUID, activityUUID, processInstanceUUID, useActivityScope, propagate, null);
    }

    public static Object evaluate(String expression, Map<String, Object> context, ProcessInstanceUUID instanceUUID, boolean propagate) throws GroovyException {
        ProcessDefinitionUUID processDefinitionUUID = null;
        if (instanceUUID != null) {
            processDefinitionUUID = instanceUUID.getProcessDefinitionUUID();
        }
        return GroovyUtil.evaluate(expression, context, processDefinitionUUID, null, instanceUUID, false, propagate, null);
    }

    public static Object evaluate(String expression, Map<String, Object> context, ProcessDefinitionUUID processUUID, boolean propagate) throws GroovyException {
        return GroovyUtil.evaluate(expression, context, processUUID, null, null, false, propagate, null);
    }

    private static Object evaluate(String expression, Map<String, Object> context, ProcessDefinitionUUID processDefinitionUUID, ActivityInstanceUUID activityUUID, ProcessInstanceUUID instanceUUID, boolean useActivityScope, boolean propagate, ClassLoader classLoader) throws GroovyException {
        int end;
        if (expression == null || "".equals(expression.trim())) {
            throw new GroovyException("The expression is null or empty");
        }
        int begin = expression.indexOf("${");
        if (begin >= (end = expression.indexOf("}"))) {
            throw new GroovyException("The expression is not a Groovy one: " + expression);
        }
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            ProcessDefinitionUUID pUUID = processDefinitionUUID;
            if (pUUID == null && instanceUUID != null) {
                pUUID = instanceUUID.getProcessDefinitionUUID();
            }
            if (pUUID == null && activityUUID != null) {
                pUUID = activityUUID.getProcessInstanceUUID().getProcessDefinitionUUID();
            }
            if (pUUID != null && classLoader == null) {
                ClassLoader processClassLoader = ClassDataLoader.getProcessClassLoader(pUUID);
                Thread.currentThread().setContextClassLoader(processClassLoader);
            } else if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            HashMap<String, Object> allVariables = new HashMap<String, Object>();
            ActivityDefinitionUUID activityDefinitionUUID = activityUUID == null ? null : activityUUID.getActivityDefinitionUUID();
            HashMap<String, Object> processRuntimeVariables = new HashMap<String, Object>();
            InternalProcessInstance instance = null;
            if (instanceUUID != null) {
                StandardQueryAPIAccessorImpl accessor = new StandardQueryAPIAccessorImpl();
                QueryRuntimeAPI api = accessor.getQueryRuntimeAPI();
                processRuntimeVariables.putAll(api.getProcessInstanceVariables(instanceUUID));
                instance = EnvTool.getAllQueriers().getProcessInstance(instanceUUID);
                List<AttachmentInstance> attachments = instance.getAttachments();
                if (attachments != null) {
                    for (AttachmentInstance attachment : attachments) {
                        allVariables.put(attachment.getName(), attachment);
                    }
                }
            }
            InternalActivityInstance activityInstance = null;
            if (activityUUID != null) {
                instance = EnvTool.getAllQueriers().getProcessInstance(activityUUID.getProcessInstanceUUID());
                activityInstance = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
                long maxDate = -1L;
                maxDate = useActivityScope && !activityInstance.getState().equals((Object)ActivityState.READY) && !activityInstance.getState().equals((Object)ActivityState.SUSPENDED) && !activityInstance.getState().equals((Object)ActivityState.EXECUTING) ? activityInstance.getLastStateUpdate().getUpdatedDate().getTime() : new Date().getTime();
                List<VariableUpdate> instanceVarUpdates = instance.getVariableUpdates();
                HashMap<String, VariableUpdate> tmp = new HashMap<String, VariableUpdate>();
                for (VariableUpdate varUpdate : instanceVarUpdates) {
                    if (varUpdate.getDate().getTime() > maxDate) continue;
                    tmp.put(varUpdate.getName(), varUpdate);
                }
                processRuntimeVariables.putAll(instance.getInitialVariableValues());
                for (VariableUpdate varUpdate : tmp.values()) {
                    processRuntimeVariables.put(varUpdate.getName(), varUpdate.getValue());
                }
                StandardQueryAPIAccessorImpl accessor = new StandardQueryAPIAccessorImpl();
                QueryRuntimeAPI api = accessor.getQueryRuntimeAPI();
                processRuntimeVariables.putAll(api.getActivityInstanceVariables(activityUUID));
            }
            InternalProcessDefinition process = null;
            if (processDefinitionUUID != null) {
                process = EnvTool.getAllQueriers().getProcess(processDefinitionUUID);
                Set<DataFieldDefinition> datafields = process.getDataFields();
                GroovyUtil.evaluateProcessDefinitionDataFields(datafields, allVariables, processRuntimeVariables);
            }
            allVariables.putAll(processRuntimeVariables);
            if (context != null) {
                allVariables.putAll(context);
            }
            SimpleBinding binding = null;
            binding = propagate ? new PropagateBinding(allVariables, processRuntimeVariables.keySet(), activityDefinitionUUID, processDefinitionUUID, process, instance, activityInstance) : new SimpleBinding(allVariables, process, instance, activityInstance);
            Object result = null;
            if (Misc.isJustAGroovyExpression(expression)) {
                expression = expression.substring("${".length());
                expression = expression.substring(0, expression.lastIndexOf("}"));
                result = GroovyUtil.evaluateGroovyExpression(expression, binding);
            } else {
                result = GroovyUtil.evaluate(GroovyUtil.getExpressions(expression), binding);
            }
            if (propagate && instanceUUID != null) {
                GroovyUtil.propagateVariables(((PropagateBinding)binding).getVariablesToPropagate(), activityUUID, instanceUUID);
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw new GroovyException(e.getMessage(), e);
        }
        finally {
            if (ori != null && ori != Thread.currentThread().getContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    private static void propagateVariables(Map<String, Object> variables, ActivityInstanceUUID activityUUID, ProcessInstanceUUID instanceUUID) throws GroovyException {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        RuntimeAPI runtime = accessor.getRuntimeAPI();
        if (variables != null) {
            for (String variable : variables.keySet()) {
                try {
                    if (activityUUID != null) {
                        runtime.setVariable(activityUUID, variable, variables.get(variable));
                        continue;
                    }
                    runtime.setProcessInstanceVariable(instanceUUID, variable, variables.get(variable));
                }
                catch (BonitaException e) {
                    throw new GroovyException(e.getMessage());
                }
            }
        }
    }

    private static Object evaluateGroovyExpression(String expression, Binding binding) {
        ClassLoader scriptClassLoader = Thread.currentThread().getContextClassLoader();
        Script script = GroovyScriptBuilder.getScript(expression, scriptClassLoader);
        script.setBinding(binding);
        return script.run();
    }

    private static String evaluate(List<String> expressions, Binding binding) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < expressions.size(); ++i) {
            String expression = expressions.get(i);
            if (expression.equals("${")) {
                expression = expressions.get(++i);
                builder.append(GroovyUtil.evaluateGroovyExpression(expression, binding));
                continue;
            }
            builder.append(expression);
        }
        return builder.toString();
    }

    private static List<String> getExpressions(String expression) {
        ArrayList<String> expressions = new ArrayList<String>();
        String concat = new String(expression);
        while (concat.contains("${")) {
            int index = concat.indexOf("${");
            expressions.add(concat.substring(0, index));
            concat = concat.substring(index);
            expressions.add("${");
            int endGroovy = Misc.getGroovyExpressionEndIndex(concat);
            expressions.add(concat.substring(2, endGroovy - 1));
            concat = concat.substring(endGroovy);
        }
        expressions.add(concat);
        return expressions;
    }

    private static void evaluateProcessDefinitionDataFields(Set<DataFieldDefinition> datafields, Map<String, Object> allVariables, Map<String, Object> processRuntimeVariables) throws GroovyException {
        if (datafields != null) {
            ArrayList<DataFieldDefinition> variables = new ArrayList<DataFieldDefinition>();
            for (DataFieldDefinition datafield : datafields) {
                if (processRuntimeVariables.containsKey(datafield.getName())) continue;
                Serializable value = datafield.getInitialValue();
                String script = datafield.getScriptingValue();
                if (value == null && script != null) {
                    variables.add(datafield);
                    continue;
                }
                allVariables.put(datafield.getName(), value);
            }
            int size = variables.size();
            int index = 0;
            int errors = 0;
            while (size > 0 && index < size) {
                DataFieldDefinition variable = (DataFieldDefinition)variables.get(index);
                try {
                    Object value = GroovyUtil.evaluate(variable.getScriptingValue(), allVariables);
                    allVariables.put(variable.getName(), value);
                    variables.remove(index);
                    size = variables.size();
                    index = 0;
                    errors = 0;
                }
                catch (GroovyException e) {
                    if (++errors == size) {
                        throw new GroovyException("Unable to evaluate: " + variable.getScriptingValue() + "on variable:" + variable.getName(), e);
                    }
                    ++index;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropagateBinding
    extends SimpleBinding {
        private Collection<String> varToPropagate = new HashSet<String>();
        private Collection<String> initialProcessVariableKeys = new HashSet<String>();
        private Collection<String> initialObjectVariables = new HashSet<String>();
        private Collection<String> initialNullVariables = new HashSet<String>();
        private ActivityDefinitionUUID activityUUID;
        private ProcessDefinitionUUID processUUID;

        public PropagateBinding(Map<String, Object> variables, Set<String> initialProcessVariableKeys, ActivityDefinitionUUID activityUUID, ProcessDefinitionUUID processUUID, InternalProcessDefinition processDefinition, InternalProcessInstance processInstance, ActivityInstance activityInstance) throws IOException, ClassNotFoundException {
            super(variables, processDefinition, processInstance, activityInstance);
            this.initialProcessVariableKeys.addAll(initialProcessVariableKeys);
            if (variables != null) {
                for (Map.Entry<String, Object> variable : variables.entrySet()) {
                    Object value = variable.getValue();
                    String varName = variable.getKey();
                    if (value != null && value instanceof ObjectVariable && initialProcessVariableKeys.contains(varName)) {
                        value = ((ObjectVariable)value).getValue();
                        this.initialObjectVariables.add(varName);
                    }
                    if (value != null) continue;
                    this.initialNullVariables.add(varName);
                }
            }
            this.activityUUID = activityUUID;
            this.processUUID = processUUID;
        }

        @Override
        public Object getVariable(String name) {
            this.varToPropagate.add(name);
            return super.getVariable(name);
        }

        @Override
        public void setVariable(String name, Object value) {
            super.setVariable(name, value);
            if (this.initialProcessVariableKeys.contains(name)) {
                this.varToPropagate.add(name);
            }
        }

        public Map<String, Object> getVariablesToPropagate() throws NotSerializableException, IOException, ClassNotFoundException, ActivityDefNotFoundException, DataFieldNotFoundException, ProcessNotFoundException {
            HashMap<String, Object> variablesToPropagate = new HashMap<String, Object>();
            for (String varName : this.varToPropagate) {
                if (!this.initialProcessVariableKeys.contains(varName)) continue;
                Object value = this.allVariables.get(varName);
                if (this.initialObjectVariables.contains(varName)) {
                    value = new ObjectVariable(value);
                } else if (this.initialNullVariables.contains(varName)) {
                    StandardQueryAPIAccessorImpl accessor = new StandardQueryAPIAccessorImpl();
                    QueryDefinitionAPI queryDefinitionAPI = accessor.getQueryDefinitionAPI("journalQueryList");
                    DataFieldDefinition datafield = null;
                    if (this.activityUUID != null) {
                        try {
                            datafield = queryDefinitionAPI.getActivityDataField(this.activityUUID, varName);
                        }
                        catch (DataFieldNotFoundException e) {
                            datafield = queryDefinitionAPI.getProcessDataField(this.activityUUID.getProcessUUID(), varName);
                        }
                    }
                    if (datafield == null && this.processUUID != null) {
                        datafield = queryDefinitionAPI.getProcessDataField(this.processUUID, varName);
                    }
                    if (datafield != null && datafield.getDataTypeClassName().equals(ObjectVariable.class.getName())) {
                        value = new ObjectVariable(value);
                    }
                }
                variablesToPropagate.put(varName, value);
            }
            return variablesToPropagate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleBinding
    extends Binding {
        Map<String, Object> allVariables = new HashMap<String, Object>();
        private InternalProcessDefinition processDefinition;
        private ProcessDefinition clientProcessDefinition;
        private InternalProcessInstance processInstance;
        private ProcessInstance clientProcessInstance;
        private ActivityInstance activityInstance;
        private ActivityInstance clientActivityInstance;

        public SimpleBinding(Map<String, Object> variables, InternalProcessDefinition processDefinition, InternalProcessInstance processInstance, ActivityInstance activityInstance) throws IOException, ClassNotFoundException {
            if (variables != null) {
                for (Map.Entry<String, Object> variable : variables.entrySet()) {
                    Object value = variable.getValue();
                    if (value != null && value instanceof ObjectVariable) {
                        value = ((ObjectVariable)value).getValue();
                    }
                    this.allVariables.put(variable.getKey(), value);
                }
            }
            this.processDefinition = processDefinition;
            this.processInstance = processInstance;
            this.activityInstance = activityInstance;
        }

        public Object getVariable(String name) {
            if ("processDefinition".equals(name)) {
                if (this.clientProcessDefinition == null && this.processDefinition != null) {
                    this.clientProcessDefinition = new ProcessDefinitionImpl(this.processDefinition);
                }
                return this.clientProcessDefinition;
            }
            if ("processInstance".equals(name)) {
                if (this.clientProcessInstance == null && this.processInstance != null) {
                    this.clientProcessInstance = new ProcessInstanceImpl(this.processInstance);
                }
                return this.clientProcessInstance;
            }
            if ("activityInstance".equals(name)) {
                if (this.clientActivityInstance == null && this.activityInstance != null) {
                    this.clientActivityInstance = new InternalActivityInstance(this.activityInstance);
                }
                return this.clientActivityInstance;
            }
            if ("loggedUser".equals(name)) {
                try {
                    return EnvTool.getUserId();
                }
                catch (Throwable e) {
                    return null;
                }
            }
            if (this.allVariables.containsKey(name)) {
                return this.allVariables.get(name);
            }
            return super.getVariable(name);
        }

        public void setVariable(String name, Object value) {
            this.allVariables.put(name, value);
        }

        public Map<String, Object> getVariables() {
            return this.allVariables;
        }
    }
}

