/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public abstract class IoUtil {
    public static final int BUFFERSIZE = 4096;

    public static byte[] readBytes(InputStream inputStream) {
        byte[] bytes = null;
        if (inputStream == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_IU_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IoUtil.transfer(inputStream, outputStream);
            bytes = outputStream.toByteArray();
            outputStream.close();
            return bytes;
        }
        catch (IOException e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_IU_2", new Object[0]);
            throw new BonitaRuntimeException(message, e);
        }
    }

    public static int transfer(InputStream in, OutputStream out) {
        int total = 0;
        byte[] buffer = new byte[4096];
        try {
            int bytesRead = in.read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                total += bytesRead;
                bytesRead = in.read(buffer);
            }
            return total;
        }
        catch (IOException e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_IU_3", new Object[0]);
            throw new BonitaRuntimeException(message, e);
        }
    }
}

